/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.StatInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoiPidController {
    private static final Logger logger = LoggerFactory.getLogger(RoiPidController.class);
    private double P = 0.0;
    private double I = 0.0;
    private double D = 0.0;
    private double F = 0.0;
    private boolean firstRun = true;
    private double errorSum = 0.0;
    private double lastOutput = 0.0;
    private double lastActual = 0.0;
    private double lastFactor = 0.0;
    private double maxIOutput = 0.0;
    private double maxError = 0.0;
    private double maxOutput = 0.0;
    private double minOutput = 0.0;
    private double outputRampRate = 0.0;
    private double outputFilter = 0.0;

    public RoiPidController() {
        this.P = Constant.DEFAULT_P;
        this.I = Constant.DEFAULT_I;
        this.D = Constant.DEFAULT_D;
        this.checkSigns();
    }

    private double getInitFactor(List<StatInfo> infos, double targetCpa) {
        double initFactor = Constant.DEFAULT_FACTOR;
        for (StatInfo info : infos) {
            if (!info.id.contains("DEFAULT")) continue;
            double actual = info.sumConv > 0.0 ? info.sumFee / info.sumConv : targetCpa;
            initFactor = targetCpa / actual;
            if (info.sumConv >= 3.0 && info.sumConv < 5.0) {
                initFactor = initFactor > 1.2 ? 1.2 : initFactor;
                initFactor = initFactor < 0.8 ? 0.8 : initFactor;
                break;
            }
            if (info.sumConv >= 5.0 && info.sumConv < 10.0) {
                if (initFactor < 1.0) {
                    initFactor = Math.pow(initFactor, 1.5);
                }
                initFactor = initFactor > 1.5 ? 1.5 : initFactor;
                initFactor = initFactor < 0.7 ? 0.7 : initFactor;
                break;
            }
            if (info.sumConv >= 10.0) {
                if (initFactor < 1.0) {
                    initFactor = Math.pow(initFactor, 2.0);
                }
                initFactor = initFactor > 2.0 ? 2.0 : initFactor;
                initFactor = initFactor < 0.5 ? 0.5 : initFactor;
                break;
            }
            if (info.sumFee < 5.0 * targetCpa) {
                initFactor = 1.0;
                break;
            }
            initFactor = targetCpa / info.sumFee;
            initFactor = initFactor > 1.5 ? 1.5 : initFactor;
            initFactor = initFactor < 0.5 ? 0.5 : initFactor;
            break;
        }
        return initFactor;
    }

    public List<StatInfo> getPriceFactor(List<StatInfo> infos, double targetCpa, double budget) {
        ArrayList<StatInfo> newInfos = new ArrayList<StatInfo>();
        double initFactor = this.getInitFactor(infos, targetCpa);
        for (StatInfo info : infos) {
            if (info.sumClick < Constant.THRESHOLD) continue;
            if (info.id.contains("ACTIVITY")) {
                info.factor = 1.0;
                info.lastSumFee = info.sumFee;
                info.lastSumConv = info.sumConv;
                newInfos.add(info);
                continue;
            }
            if (!this.checkParam(info, targetCpa) || !this.checkStart(info, targetCpa)) continue;
            if (info.id.contains("APP") || info.id.contains("SLOT")) {
                info.factor = this.getOnePriceFactor(info, targetCpa, budget, initFactor);
            } else if (info.id.contains("DEFAULT")) {
                double lastfactor = info.factor;
                if (info.lastSumFee == 0.0) {
                    lastfactor = 1.0;
                }
                info.factor = Math.max(lastfactor * 0.8, initFactor);
                info.factor = Math.min(lastfactor * 1.2, initFactor);
            }
            info.lastSumFee = info.sumFee;
            info.lastSumConv = info.sumConv;
            newInfos.add(info);
        }
        return newInfos;
    }

    private double init(StatInfo info, double targetCpa, double budget, double initFactor) {
        this.lastFactor = info.factor;
        if (info.lastSumFee == 0.0 && Math.abs(info.factor - 1.0) < 1.0E-5) {
            info.factor = initFactor;
        } else if (info.lastSumFee == 0.0) {
            info.factor = info.factor < initFactor * 0.6 ? initFactor * 0.6 : info.factor;
            double d = info.factor = info.factor > initFactor * 1.4 ? initFactor * 1.4 : info.factor;
            if (info.factor > 1.0 && initFactor < 1.0) {
                info.factor = 1.0;
            }
        }
        double beforeFactor = info.factor;
        info.factor = this.smoothInitWith7d(info, targetCpa, budget, info.factor);
        if (Math.abs(beforeFactor - info.factor) > 0.1) {
            logger.info("pid controller smooth Id:{} beforeFactor:{} afterFactor:{} ", new Object[]{info.id, beforeFactor, info.factor});
        }
        if (info.sumConv >= 5.0) {
            double actual = info.sumFee / info.sumConv;
            this.setOutputLimits(targetCpa);
            this.lastOutput = info.lastSumConv > 0.0 ? this.lastFactor * targetCpa - 1.0 : 0.0;
            this.lastActual = info.lastSumConv > 0.0 ? info.lastSumFee / info.lastSumConv : actual;
            this.maxError = 100.0;
            this.errorSum = this.constrain(info.lastSumConv * targetCpa - info.lastSumFee, -this.maxError, this.maxError);
            double output = this.getOutput(actual, targetCpa);
            info.factor = this.adjust(output, info.factor, this.lastFactor, targetCpa, 0.9, 1.1);
            double rFactor = targetCpa / actual;
            info.factor = output < 0.0 && info.factor > rFactor ? rFactor : info.factor;
            info.factor = output > 0.0 && info.factor < rFactor ? rFactor : info.factor;
            info.factor = output < 0.0 ? Math.max(info.factor, this.lastFactor * 0.8) : Math.min(info.factor, this.lastFactor * 1.4);
        }
        return info.factor;
    }

    private double boot(StatInfo info, double targetCpa, double budget, double initFactor) {
        this.lastFactor = info.factor;
        if (info.sumConv > 0.0) {
            double actual = info.sumFee / info.sumConv;
            this.setOutputLimits(targetCpa);
            this.lastOutput = info.lastSumConv > 0.0 ? this.lastFactor * targetCpa - 1.0 : 0.0;
            this.lastActual = info.lastSumConv > 0.0 ? info.lastSumFee / info.lastSumConv : actual;
            this.maxError = 100.0;
            this.errorSum = this.constrain(info.lastSumConv * targetCpa - info.lastSumFee, -this.maxError, this.maxError);
            double output = this.getOutput(actual, targetCpa);
            info.factor = this.adjust(output, info.factor, this.lastFactor, targetCpa, 0.9, 1.1);
        } else {
            info.factor = info.sumFee > 2.0 * targetCpa ? Math.min(initFactor * 0.9, info.factor) : Math.min(initFactor, info.factor);
        }
        info.factor = Math.max(info.factor, initFactor * 0.5);
        info.factor = Math.min(info.factor, initFactor * 1.4);
        return info.factor;
    }

    private double run(StatInfo info, double targetCpa, double budget, double initFactor) {
        this.lastFactor = info.factor;
        double actual = info.sumConv > 0.0 ? info.sumFee / info.sumConv : info.sumFee * 2.0;
        this.setOutputLimits(targetCpa);
        this.lastOutput = info.lastSumConv > 0.0 ? this.lastFactor * targetCpa - 1.0 : 0.0;
        this.lastActual = info.lastSumConv > 0.0 ? info.lastSumFee / info.lastSumConv : actual;
        this.maxError = 100.0;
        this.errorSum = this.constrain(info.lastSumConv * targetCpa - info.lastSumFee, -this.maxError, this.maxError);
        double output = this.getOutput(actual, targetCpa);
        info.factor = info.factor > 0.6 && info.factor < 1.0 ? this.adjust(output, info.factor, this.lastFactor, targetCpa, 0.8, 1.1) : this.adjust(output, info.factor, this.lastFactor, targetCpa, 0.9, 1.1);
        double rFactor = targetCpa / actual;
        if (targetCpa >= 3000.0 && info.sumFee < 5.0 * targetCpa) {
            info.factor = Math.max(info.factor, initFactor * 0.5);
        }
        info.factor = Math.max(info.factor, initFactor * 0.2);
        info.factor = Math.min(info.factor, initFactor * 2.0);
        if (info.sumConv >= 5.0 && info.sumConv < 10.0) {
            info.factor = output < 0.0 && info.factor > rFactor ? rFactor : info.factor;
            info.factor = output > 0.0 && info.factor < rFactor ? rFactor : info.factor;
            info.factor = output < 0.0 ? Math.max(info.factor, this.lastFactor * 0.85) : Math.min(info.factor, this.lastFactor * 1.3);
        } else if (info.sumConv >= 10.0) {
            info.factor = output < 0.0 && info.factor > rFactor ? rFactor : info.factor;
            info.factor = output > 0.0 && info.factor < rFactor ? rFactor : info.factor;
            info.factor = output < 0.0 ? Math.max(info.factor, this.lastFactor * 0.7) : Math.min(info.factor, this.lastFactor * 1.4);
        }
        return info.factor;
    }

    private double smoothInitWith7d(StatInfo info, double targetCpa, double budget, double initFactor) {
        class LocalConstant {
            double minConfi = 0.8;
            double minCpcGap = 0.3;
            double defaultFactor = 1.0;

            LocalConstant() {
            }
        }
        LocalConstant constant = new LocalConstant();
        double cpa7d = info.conv7d > 0.0 ? info.fee7d / info.conv7d : -1.0;
        double cpa1d = info.lastSumConv > 0.0 ? info.lastSumFee / info.lastSumConv : -1.0;
        double cpc1d = info.sumClick > 0.0 ? (info.sumFee - info.lastSumFee) / info.sumClick : -1.0;
        double cpc7d = info.click7d > 0.0 ? info.fee7d / info.click7d : -1.0;
        double confi7d = this.getConfidence(info.fee7d / targetCpa, 10.0);
        double confi1d = this.getConfidence(info.lastSumConv, 10.0);
        double bias7d = targetCpa / cpa7d;
        double bias1d = targetCpa / cpa1d;
        InitStatus stat = InitStatus.unkown;
        if (cpa7d == -1.0 || cpa1d == -1.0 || cpc1d == -1.0 || cpc7d == -1.0) {
            return initFactor;
        }
        if (Math.abs(cpc1d - cpc7d) < cpc1d * constant.minCpcGap && confi7d > constant.minConfi) {
            stat = bias7d < constant.defaultFactor && initFactor < constant.defaultFactor ? InitStatus.low : (bias7d > constant.defaultFactor && initFactor > constant.defaultFactor ? InitStatus.high : InitStatus.contradict);
        }
        double newInitFactor = initFactor;
        switch (stat) {
            case low: {
                newInitFactor = Math.min(bias7d, initFactor);
                break;
            }
            case high: {
                newInitFactor = Math.max(bias7d, initFactor);
                break;
            }
            case contradict: {
                newInitFactor = (1.0 - confi1d) * bias7d + confi1d * initFactor;
                break;
            }
            default: {
                newInitFactor = initFactor;
            }
        }
        return newInitFactor;
    }

    private double smoothWith7d(StatInfo info, double targetCpa, double budget, double factor) {
        class LocalConstant {
            double minConfi = 0.8;
            double minCpcGap = 0.1;
            double defaultFactor = 1.0;

            LocalConstant() {
            }
        }
        LocalConstant constant = new LocalConstant();
        double cpa7d = info.conv7d > 0.0 ? info.fee7d / info.conv7d : -1.0;
        double cpa1d = info.lastSumConv > 0.0 ? info.lastSumFee / info.lastSumConv : -1.0;
        double cpc1d = info.sumClick > 0.0 ? (info.sumFee - info.lastSumFee) / info.sumClick : -1.0;
        double cpc7d = info.click7d > 0.0 ? info.fee7d / info.click7d : -1.0;
        double confi7d = this.getConfidence(info.fee7d / targetCpa, 50.0);
        double confi1d = this.getConfidence(info.lastSumConv, 20.0);
        double bias7d = cpa7d / targetCpa;
        double bias1d = cpa1d / targetCpa;
        if (cpa7d == -1.0 || cpa1d == -1.0 || cpc1d == -1.0 || cpc7d == -1.0) {
            return factor;
        }
        InitStatus stat = InitStatus.unkown;
        if (Math.abs(cpc1d - cpc7d) < constant.minCpcGap && confi7d > constant.minConfi && confi1d > constant.minConfi) {
            stat = bias7d < constant.defaultFactor && factor < constant.defaultFactor ? InitStatus.low : (bias7d > constant.defaultFactor && factor > constant.defaultFactor ? InitStatus.high : InitStatus.contradict);
        }
        switch (stat) {
            case low: {
                factor = Math.min(bias7d, factor);
                break;
            }
            case high: {
                factor = Math.max(bias7d, factor);
                break;
            }
            case contradict: {
                factor = confi7d * bias7d + (1.0 - confi7d) * factor;
                break;
            }
        }
        return factor;
    }

    private double getConfidence(double cur, double max) {
        return cur < max ? cur / max : 1.0;
    }

    private double getOnePriceFactor(StatInfo info, double targetCpa, double budget, double initFactor) {
        this.reset();
        if (initFactor < 0.9) {
            targetCpa *= 0.85;
        }
        if (info.lastSumFee == 0.0) {
            return this.init(info, targetCpa, budget, initFactor);
        }
        if (this.checkColdboot(info, targetCpa)) {
            return this.boot(info, targetCpa, budget, initFactor);
        }
        return this.run(info, targetCpa, budget, initFactor);
    }

    private double adjust(double output, double factor, double lastFactor, double targetCpa, double negtive, double positive) {
        factor = output < 0.0 ? lastFactor * Math.max(1.0 + output / targetCpa, negtive) : lastFactor * Math.min(1.0 + output / targetCpa, positive);
        return factor;
    }

    private boolean checkParam(StatInfo info, double targetCpa) {
        return !(info.sumFee <= 0.0 || info.sumConv < 0.0 || info.lastSumFee < 0.0 || info.lastSumConv < 0.0 || info.factor <= 0.0) && !(targetCpa <= 0.0);
    }

    private boolean checkStart(StatInfo info, double targetCpa) {
        return !(info.sumFee <= 3000.0) || !(info.sumConv < 1.0);
    }

    private boolean checkColdboot(StatInfo info, double targetCpa) {
        return info.sumConv < 5.0 && info.sumFee / targetCpa < 5.0;
    }

    private RoiPidController(double p, double i, double d) {
        this.P = p;
        this.I = i;
        this.D = d;
        this.checkSigns();
    }

    private RoiPidController(double p, double i, double d, double f) {
        this.P = p;
        this.I = i;
        this.D = d;
        this.F = f;
        this.checkSigns();
    }

    private void setI(double i) {
        if (this.I != 0.0) {
            this.errorSum = this.errorSum * this.I / i;
        }
        if (this.maxIOutput != 0.0) {
            this.maxError = this.maxIOutput / i;
        }
        this.I = i;
        this.checkSigns();
    }

    private void setPID(double p, double i, double d) {
        this.P = p;
        this.D = d;
        this.setI(i);
        this.checkSigns();
    }

    private void setPID(double p, double i, double d, double f) {
        this.P = p;
        this.D = d;
        this.F = f;
        this.setI(i);
        this.checkSigns();
    }

    private void setMaxIOutput(double maximum) {
        this.maxIOutput = maximum;
        if (this.I != 0.0) {
            this.maxError = this.maxIOutput / this.I;
        }
    }

    private void setOutputLimits(double output) {
        this.setOutputLimits(-output, output);
    }

    private void setOutputLimits(double minimum, double maximum) {
        if (maximum < minimum) {
            return;
        }
        this.maxOutput = maximum;
        this.minOutput = minimum;
        if (this.maxIOutput == 0.0 || this.maxIOutput > maximum - minimum) {
            this.setMaxIOutput(maximum - minimum);
        }
    }

    private double getOutput(double actual, double setpoint) {
        double error = setpoint - actual;
        double Foutput = this.F * setpoint;
        double Poutput = this.P * error;
        if (this.firstRun) {
            this.lastActual = actual;
            this.lastOutput = Poutput + Foutput;
            this.firstRun = false;
        }
        double Doutput = -this.D * (actual - this.lastActual);
        this.lastActual = actual;
        double Ioutput = this.I * this.errorSum;
        if (this.maxIOutput != 0.0) {
            Ioutput = this.constrain(Ioutput, -this.maxIOutput, this.maxIOutput);
        }
        double output = Foutput + Poutput + Ioutput + Doutput;
        this.errorSum = this.minOutput != this.maxOutput && !this.bounded(output, this.minOutput, this.maxOutput) ? error : (this.outputRampRate != 0.0 && !this.bounded(output, this.lastOutput - this.outputRampRate, this.lastOutput + this.outputRampRate) ? error : (this.maxIOutput != 0.0 ? this.constrain(this.errorSum + error, -this.maxError, this.maxError) : (this.errorSum += error)));
        if (this.outputRampRate != 0.0) {
            output = this.constrain(output, this.lastOutput - this.outputRampRate, this.lastOutput + this.outputRampRate);
        }
        if (this.minOutput != this.maxOutput) {
            output = this.constrain(output, this.minOutput, this.maxOutput);
        }
        if (this.outputFilter != 0.0) {
            output = this.lastOutput * this.outputFilter + output * (1.0 - this.outputFilter);
        }
        this.lastOutput = output;
        return output;
    }

    private void reset() {
        this.firstRun = true;
        this.errorSum = 0.0;
    }

    private void setOutputRampRate(double rate) {
        this.outputRampRate = rate;
    }

    private void setOutputFilter(double strength) {
        if (strength == 0.0 || this.bounded(strength, 0.0, 1.0)) {
            this.outputFilter = strength;
        }
    }

    private double constrain(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    private boolean bounded(double value, double min, double max) {
        return min < value && value < max;
    }

    private void checkSigns() {
        if (this.P < 0.0) {
            this.P *= -1.0;
        }
        if (this.I < 0.0) {
            this.I *= -1.0;
        }
        if (this.D < 0.0) {
            this.D *= -1.0;
        }
        if (this.F < 0.0) {
            this.F *= -1.0;
        }
    }

    public static void main(String[] args) {
        String test2 = "11789_0_ACTIVITY_23032_1_1092";
        RoiPidController PID = new RoiPidController();
        StatInfo s1 = new StatInfo();
        s1.id = "11789_0_APP_2303";
        s1.sumFee = 3000.0;
        s1.sumConv = 1.0;
        s1.lastSumConv = 0.0;
        s1.lastSumFee = 0.0;
        s1.sumClick = 100.0;
        s1.factor = 0.8;
        s1.parentFactor = 1.0;
        StatInfo s2 = new StatInfo();
        s2.id = "11789_0_ACTIVITY_23032_1_1092";
        s2.sumFee = 3000.0;
        s2.sumConv = 0.0;
        s2.lastSumConv = 0.0;
        s2.lastSumFee = 0.0;
        s2.sumClick = 100.0;
        s2.factor = 1.0;
        ArrayList<StatInfo> infos = new ArrayList<StatInfo>();
        infos.add(s1);
        infos.add(s2);
        double bidOld = 1500.0;
        double maxConv = 100.0;
        double targetCpa = 3000.0;
        double actualCpa = s1.sumFee / s1.sumConv;
        double budget = 30000.0;
        double bid = bidOld;
        for (int i = 0; i < 200; ++i) {
            double factor = 1.0;
            System.err.printf("%3.2f\t%3.2f\t%3.2f\t%3.2f\t%3.0f\t%3.0f\t%3.0f\t%3.0f\t%3.0f\n", targetCpa, actualCpa, s1.factor, s2.factor, bid, s1.sumFee, s1.sumConv, s1.lastSumFee, s1.lastSumConv);
            List<StatInfo> newinfos = PID.getPriceFactor(infos, targetCpa, budget);
            double random = 1.0;
            double random1 = Math.random();
            double random2 = Math.random();
            random = random1 > random2 ? 1.0 + random1 : 1.0 - random2;
            bid = bidOld * s1.factor;
            bid = Math.max(bid, 1.0);
            bid = Math.min(3000.0, bid);
            double conv = Math.min(Math.pow(1.5, bid / 100.0), maxConv);
            s1.sumFee += bid * conv;
            s1.sumConv += conv;
            actualCpa = s1.sumFee / s1.sumConv;
        }
    }

    public static enum InitStatus {
        low,
        high,
        contradict,
        unkown;

    }

    static class Constant {
        static double DEFAULT_FACTOR = 1.0;
        static double THRESHOLD = 20.0;
        static double DEFAULT_P = 0.5;
        static double DEFAULT_I = 0.01;
        static double DEFAULT_D = 0.5;

        Constant() {
        }
    }

    public static enum RunStatus {
        COLDBOOT,
        CHANGING,
        STAMBLE;

    }

    public static enum LifeStatus {
        NORMAL,
        DIE;

    }
}

