package cn.com.duiba.nezha.compute.common.model.activityselectconversion;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;


public class ActivitySelector {

    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;  //100次以前的观察，无效
        static int SEARANK_TOPN = 30;
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double gchange;
        double hrpm;
        double hexp;
        double hchange;
        double arpm;
        double aexp;
        double achange;

    }

    static class SelectInfo {
        double reward;
        long activityType;
        int index;
        long activityId;
        double changeScore;
    }

    static class MatchInfo {
        double score;
        ActivityInfoModel act;
    }

    public static  int getCoef(double hisRequest, double request, double hisClick, double click)
    {
        int coef = 1;
        int i = 1,j=1;
        if(request < 0)
        {
            for(i = 1;i<144;i++)
            {
                request += hisRequest/144;
                if(request > 0)
                    break;
            }
        }
        if(click < 0)
        {
            for(j = 1;j<144;j++)
            {
                click += hisClick/144;
                if(click > 0)
                    break;
            }
        }
        coef = coef + Math.max(i,j);
        return coef;
    }

    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>() {

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int) (c2.score - c1.score >= 0 ? 1 : -1); //按score大小排序
        }
    };

    private static List<ActivityInfoModel> sortByIdAndSourceModel(List<ActivityInfoModel> acts){

        List<ActivityInfoModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoModel>() {
            public int compare(ActivityInfoModel act1, ActivityInfoModel act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }

    private static List<ActivityInfoData> sortByIdAndSourceData(List<ActivityInfoData> acts){

        List<ActivityInfoData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoData>() {
            public int compare(ActivityInfoData act1, ActivityInfoData act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }

    private static List<ActivityInfoAd> sortByIdAndSourceAd(List<ActivityInfoAd> acts){

        List<ActivityInfoAd> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoAd>() {
            public int compare(ActivityInfoAd act1, ActivityInfoAd act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }


    private static List<ActivityModel> sortByIdAndSourceModelBack(List<ActivityModel> acts){
        List<ActivityModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityModel>() {
            public int compare(ActivityModel act1, ActivityModel act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;



    }

    private static List<ActivityData> sortByIdAndSourceDataBack(List<ActivityData> acts){

        List<ActivityData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityData>() {
            public int compare(ActivityData act1, ActivityData act2) {
                if(act1.activityId > act2.activityId) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }




    //recall
    //外部调用
    public static List<ActivityInfoModel> match (List<ActivityInfoModel> actModel,List<ActivityInfoData> actData,List<ActivityInfoAd> actAd) { //TODO 命名不规范



        int topn = Constant.SEARANK_TOPN;
        List<ActivityInfoModel> result = new ArrayList<ActivityInfoModel>();
        List<ActivityInfoModel> actModelCopy = new ArrayList<ActivityInfoModel>();

        Queue<MatchInfo> candis = new PriorityQueue<>(actData.size(), iComparator);
        Queue<MatchInfo> slotCandis = new PriorityQueue<>(actData.size(), iComparator);
        Queue<MatchInfo> appCandis = new PriorityQueue<>(actData.size(), iComparator);
        Queue<MatchInfo> globalCandis = new PriorityQueue<>(actData.size(), iComparator);


        //排序
        List<ActivityInfoData> actDataCopy =  sortByIdAndSourceData(actData);
        HashMap<Long,ActivityInfoAd> adHashMap = new HashMap<Long,ActivityInfoAd>();

        for(int i = 0;i < actAd.size();++i){
            adHashMap.put(actAd.get(i).activityId,actAd.get(i));
        }


        long size_act = actDataCopy.size();

        //判断列表是否相等，不相等抛异常

        //同时遍历
        for (int i = 0;i < size_act;++i) {
            try {
                ActivityInfoModel actM = new ActivityInfoModel();
                actM.activityId = actDataCopy.get(i).activityId;
                actM.slotId = actDataCopy.get(i).slotId;
                actM.appId = actDataCopy.get(i).appId;


                //更新历史数据
                actM.hisClick.globalVal = actDataCopy.get(i).click.globalVal;
                actM.hisClick.appVal = actDataCopy.get(i).click.appVal;
                actM.hisClick.slotVal = actDataCopy.get(i).directClick.slotVal;

                actM.hisCost.globalVal = actDataCopy.get(i).cost.globalVal;
                actM.hisCost.appVal = actDataCopy.get(i).cost.appVal;
                actM.hisCost.slotVal = actDataCopy.get(i).directCost.slotVal;
//                System.out.println("actModelCopy.get("+actM.activityId+").hisCost.appVal="+actM.hisCost.appVal);

                actM.hisRequest.globalVal = actDataCopy.get(i).request.globalVal;
                actM.hisRequest.appVal = actDataCopy.get(i).request.appVal;
                actM.hisRequest.slotVal = actDataCopy.get(i).directRequest.slotVal;
                actModelCopy.add(actM);

//                System.out.println("actDataCopy.get(i).request.globalVal="+actDataCopy.get(i).request.globalVal);
                //新活动试投
                int limit = topn;
                if (actM.hisRequest.globalVal < 100) { //全局活动请求数少于100
                    //continue;
                    if(System.currentTimeMillis() - actDataCopy.get(i).createTime < 60 * 1000 * 60 * 24 * 3) //上架时间小于三天
                    {
                        if (Math.random() < 0.0001) { //小于0.0001进行试投
                            result.add(actM);
                            topn--; //占用一个名额
                        }
                    }
                    else if (actDataCopy.size() > limit) { //为什么
                        if (Math.random() < 0.00001) {  //小于0.00001进行试投
                            result.add(actM);
                            topn--;//占用一个名额
                        }
                    }

                } else {
                    //计算matchscore
                    double slotScore = WilsonInterval.wilsonCalc((long) actM.hisClick.slotVal, (long) actM.hisRequest.slotVal * 3).lowerBound;
                    double globalScore = WilsonInterval.wilsonCalc((long) actM.hisClick.globalVal, (long) actM.hisRequest.globalVal * 3).lowerBound;
                    double appScore = WilsonInterval.wilsonCalc((long) actM.hisClick.appVal, (long) actM.hisRequest.appVal * 3).lowerBound;
                    //为什么乘以3
                    double coef = 0, matchscore = 0;

                    double sconfidence = Math.min(actM.hisRequest.slotVal / 100, 1);
                    double aconfidence = Math.min(actM.hisRequest.appVal / 100, 1);
                    double gconfidence = Math.min(actM.hisRequest.globalVal / 1000, 1);


                    matchscore = sconfidence * slotScore
                            + (1 - sconfidence) * aconfidence * appScore * 0.9
                            + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);

                    double changeScore = 0.0d;
                    if(adHashMap.containsKey(actDataCopy.get(i).activityId)) {
                        changeScore = calChangeScore(adHashMap.get(actDataCopy.get(i).activityId).getAdverts()); //TODO
                    }

//                    System.out.println(actM.activityId+" changeScore="+changeScore);
                    actM.changeScore = changeScore;

                    //当slotScore<100的时候，才会启用appScore和globalScore

                    //计算 changeScore


                    MatchInfo info = new MatchInfo();
                    info.act = actM;
                    info.score = matchscore;
                    candis.add(info);

                    if (sconfidence > 0.99 || actM.hisClick.slotVal > 5) { //广告位请求数大于99 或点击大于5
                        MatchInfo info2 = new MatchInfo();
                        info2.act = actM;
                        //分数是消耗除以请求数
                        info2.score = actM.hisRequest.slotVal > 0 ? actM.hisCost.slotVal / actM.hisRequest.slotVal : 0;

                        slotCandis.add(info2);
                    }

                    if (aconfidence > 0.99 || actM.hisClick.slotVal > 5) { //app请求数大于99 或点击大于5
                        MatchInfo info2 = new MatchInfo();
                        info2.act = actM;
                        //分数是消耗除以请求数
                        info2.score = actM.hisRequest.appVal > 0 ? actM.hisCost.appVal / actM.hisRequest.appVal : 0;
                        appCandis.add(info2);
                    }

                }
            }catch (Exception e)
            {
//                logger.error("error, act:{}", JSON.toJSONString(actM));
                logger.error(e.getMessage(), e);
//                System.out.println(e.getMessage());
            }
        }

        HashSet<Long> idset = new HashSet();


        int size1 = slotCandis.size();
        for (int i = 0; i < 10 && i < size1; i++) {
            ActivityInfoModel act =  slotCandis.poll().act;
            result.add(act);
            idset.add(act.activityId);

        }

        int size = candis.size();
        for (int i = 0; i < topn && i < size; i++) {
            ActivityInfoModel act =  candis.poll().act;
            if(idset.contains(act.activityId))
                continue;
            result.add(act);
            idset.add(act.activityId);
        }

        if(result.size() < topn)
        {
            int count = topn;
            for (int i = 0;i < size_act;++i){

                if(idset.contains(actDataCopy.get(i).activityId))
                    continue;
                idset.add(actDataCopy.get(i).activityId);
                actModelCopy.get(i).hisClick.globalVal = actDataCopy.get(i).click.globalVal;
                actModelCopy.get(i).hisClick.appVal = actDataCopy.get(i).click.appVal;
                actModelCopy.get(i).hisClick.slotVal = actDataCopy.get(i).directClick.slotVal;

                actModelCopy.get(i).hisCost.globalVal = actDataCopy.get(i).cost.globalVal;
                actModelCopy.get(i).hisCost.appVal = actDataCopy.get(i).cost.appVal;
                actModelCopy.get(i).hisCost.slotVal = actDataCopy.get(i).directCost.slotVal;

                actModelCopy.get(i).hisRequest.globalVal = actDataCopy.get(i).request.globalVal;
                actModelCopy.get(i).hisRequest.appVal = actDataCopy.get(i).request.appVal;
                actModelCopy.get(i).hisRequest.slotVal = actDataCopy.get(i).directRequest.slotVal;



                result.add( actModelCopy.get(i));
                count++;
                if(count >= topn)
                    break;

            }
        }
        return result;
    }

    //100 - 10 - 1
    //后端调用
    public static ActivityModel select(List<ActivityModel> actModel,List<ActivityData> actData,double gama) {


        //1.判断列表长度，不一致抛异常
        if(actModel.size() != actData.size()){
            return actModel.get(0); //todo 抛异常
        }
        List<ActivityModel> actModelCopy =  sortByIdAndSourceModelBack(actModel);
        List<ActivityData> actDataCopy =  sortByIdAndSourceDataBack(actData);
        //活动 id 对不上返回空
        for(int i = 0; i< actModelCopy.size();++i) {
            long activityIdMode = actModelCopy.get(i).activityId;
            long activityIdData = actDataCopy.get(i).activityId;
            if (activityIdMode != activityIdData) {
                return actModel.get(0); // todo 抛异常
            }
        }

        //2.排序

        //1、init
        ArrayList<Double> rewards = new ArrayList<>();
        ArrayList<Double> counts = new ArrayList<>();
        ArrayList<Double> alphas = new ArrayList<>();
        ArrayList<Double> betas = new ArrayList<>();
        ArrayList<Double> changeScores = new ArrayList<>();
        ArrayList<Long> activityIds = new ArrayList<>();
        ArrayList<Long> activityTypes = new ArrayList<>();

        List<ActivityModel> candiList = new ArrayList<>();

        double decay = Constant.DECAY;

        int size = 0;

        HashMap<Long, RankInfo> mMap = new HashMap();
        double maxG = Constant.MIN_REWARD, maxH = Constant.MIN_REWARD, maxA = Constant.MIN_REWARD;
        double maxGchange = Constant.MIN_REWARD, maxHchange = Constant.MIN_REWARD, maxAchange = Constant.MIN_REWARD;
        ActivityModel result = new ActivityModel();

        try {

            //2、match


            //3、rank
            //3.1 get info
            for (int i = 0;i<actDataCopy.size();++i) {
                //get global data Click
                RankInfo info = mMap.containsKey(actDataCopy.get(i).activityId) ? mMap.get(actDataCopy.get(i).activityId) : new RankInfo();
                double grpm = actDataCopy.get(i).hisRequest.globalVal > 0 ? actDataCopy.get(i).hisCost.globalVal / actDataCopy.get(i).hisRequest.globalVal : 0;

                info.grpm = grpm;
                info.gexp = actDataCopy.get(i).hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);


                //get app data Cost
                double arpm = actDataCopy.get(i).hisRequest.appVal > 0 ? actData.get(i).hisCost.appVal / actData.get(i).hisRequest.appVal : 0;

                info.arpm = arpm;
                info.aexp = actDataCopy.get(i).hisRequest.appVal;
                if (info.hexp > 50) {
                    maxA = Math.max(arpm, maxA);

                }


                //get slot data Cost
                double hrpm = actDataCopy.get(i).hisRequest.slotVal > 0 ? actData.get(i).hisCost.slotVal / actData.get(i).hisRequest.slotVal : 0;

                info.hrpm = hrpm;
                info.hexp = actDataCopy.get(i).hisRequest.slotVal;



                //System.out.println(hrpm+"\t"+maxH);

                mMap.put(actDataCopy.get(i).activityId, info);
            }

            for (int i = 0;i<actDataCopy.size();++i) {

                    double reward = Constant.MIN_REWARD;
                    double sconfidence = Math.min(actDataCopy.get(i).hisRequest.slotVal / 60, 1);
                    double aconfidence = Math.min(actDataCopy.get(i).hisRequest.appVal / 60, 1);

                    reward = sconfidence * normlize(mMap.get(actDataCopy.get(i).activityId).hrpm * 0.8, maxH, 0.8) +
                            (1 - sconfidence) * aconfidence * normlize(mMap.get(actDataCopy.get(i).activityId).arpm * 0.7, maxA, 0.7) +
                            (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(mMap.get(actDataCopy.get(i).activityId).grpm * 0.5, maxG, 0.6);

                    System.out.println(actDataCopy.get(i)+" reward="+reward);
                    reward = reward * reward;

                    reward = Math.max(reward, Constant.MIN_REWARD);

                    actModelCopy.get(i).reward = actModelCopy.get(i).reward * decay + reward;
                    actModelCopy.get(i).count = actModelCopy.get(i).count * decay + 1.0;
                    actModelCopy.get(i).alpha = 1.5 + actModelCopy.get(i).reward;
                    actModelCopy.get(i).beta = 2.0 + (actModelCopy.get(i).count - actModelCopy.get(i).reward);


                rewards.add(actModelCopy.get(i).reward);
                counts.add(actModelCopy.get(i).count);
                alphas.add(actModelCopy.get(i).alpha);
                betas.add(actModelCopy.get(i).beta);
                activityTypes.add(actModelCopy.get(i).activityType);
                activityIds.add(actModelCopy.get(i).activityId);
                changeScores.add(actModelCopy.get(i).changeScore);
                candiList.add(actModelCopy.get(i));
            }

            //4、select


            int numMachines = candiList.size();

            result = candiList.get(selectMachineWithChangeScore(alphas, betas,activityTypes, activityIds,changeScores,numMachines,gama));


            mMap.clear();

            //System.out.println(result.activityId);


            return result;
        }catch (Exception e)
        {
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", size, JSON.toJSONString(candiList), JSON.toJSONString(result));
        }

        return result;
    }

    public static  void print(ActivityInfo act)
    {
        System.out.println("-----------"+act.activityId+"-----------");
        System.out.println("request = "+act.request.slotVal+"\t"+act.request.appVal+"\t"+act.request.globalVal);
        System.out.println("click = "+act.click.slotVal+"\t"+act.click.appVal+"\t"+act.click.globalVal);
        System.out.println("lastRequest = "+act.lastRequest.slotVal+"\t"+act.lastRequest.appVal+"\t"+act.lastRequest.globalVal);
        System.out.println("lastClick = "+act.lastClick.slotVal+"\t"+act.lastClick.appVal+"\t"+act.lastClick.globalVal);
        System.out.println("hisRequest = "+act.hisRequest.slotVal+"\t"+act.hisRequest.appVal+"\t"+act.hisRequest.globalVal);
        System.out.println("hisClick = "+act.hisClick.slotVal+"\t"+act.hisClick.appVal+"\t"+act.hisClick.globalVal);
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }


    public ActivitySelector() { //下周

    }

    public static double calChangeScore(List<Advert> ads) {
        double changeScore = 0.0d;
        double sumClick = 0.0d;
        double sumEffectPV = 0.0d;
        for(Advert ad:ads){
            sumClick += ad.click;
            sumEffectPV += ad.effectPV;
        }
        for(Advert ad:ads){//计算转化分
            double changeMore = ad.click > 0 ? (double) ad.effectPV / (double) ad.click : 0 ;
            changeMore = ad.globalCvr > 0 ? changeMore/ad.globalCvr :0;
            changeMore -= 1;
            double ratio = sumClick > 0 ? ad.click/sumClick:0;
            changeScore += ratio * changeMore;
        }
        return sumEffectPV > 3 ?changeScore:0;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0;

        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));

            if (theta > maxTheta) {
                maxTheta = theta;
                selectMachine = i;
            }
        }
        return selectMachine;
    }




    //卡包分版本
    private static int selectMachineWithChangeScore(List<Double> alphas, List<Double> betas,List<Long> activityTypes,List<Long> activityIds,List<Double> changeScores, int numMachines,double gama) {
        int selectMachine = 0;
        ArrayList<SelectInfo> sinfos = new  ArrayList<SelectInfo>();
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectInfo sinfo = new SelectInfo();
//            System.out.println(activityIds.get(i)+"= "+theta);
            sinfo.reward = theta;
            sinfo.activityType = activityTypes.get(i);
            sinfo.index = i;
            sinfo.activityId = activityIds.get(i);
            sinfo.changeScore = changeScores.get(i);
            sinfos.add(sinfo);
        }

        Collections.sort(sinfos, new Comparator<SelectInfo>() {
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if(sinfo1.reward > sinfo2.reward) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });


        ArrayList<SelectInfo> condi = new ArrayList<SelectInfo>();
        for(int i = 0;i < sinfos.size();++i) {
            if(sinfos.get(0).reward - sinfos.get(i).reward <= gama) { //生成消耗分接近的候选集
                System.out.println("condi "+i+" activityId="+sinfos.get(i).activityId+" theta="+sinfos.get(i).reward+" "+" activityType="+sinfos.get(i).activityType+" changeScore="+changeScores.get(i));
                condi.add(sinfos.get(i));
            }
        }
        Collections.sort(condi, new Comparator<SelectInfo>() {
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if(sinfo1.changeScore > sinfo2.changeScore) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
//        System.out.println(condi.get(0).activityId+"="+condi.get(0).changeScore);
//        System.out.println(condi.get(1).activityId+"="+condi.get(1).changeScore);
        selectMachine = condi.get(0).index; //选取一定范围内转化最高的
        for(int i = 0; i < condi.size();++i) {
            if(condi.get(i).activityType != 21){
                selectMachine = condi.get(i).index; //选取消耗分最大的非卡包
                break;
            }
        }

//        System.out.println("sinfos="+sinfos.get(0).activityId);
//        System.out.println("sinfos="+sinfos.get(1).activityId);
//        return  sinfos.get(0).index;
//        System.out.println("selectMachine="+selectMachine);
        return selectMachine;

    }




    private double getCtr(double exp, double clk) {
        return exp > 0 ? clk / exp : 0;
    }

    private double sum(List<Long> list) {
        double sum = 0;
        for (Long val : list) {
            sum += val;
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null)
            return 0;
        long fenzi = (long) (ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null)
            return 0;
        if (ratio == 0) {
            ratio = 0.00000001;
        }
        long fenmu = (long) (num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null)
            return 0;
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi.longValue(), fenmu.longValue());
        return pair.lowerBound;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }
}