package cn.com.duiba.nezha.compute.common.model.pacing;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Calendar;
import java.util.List;

/**
 * Created by jiali on 2017/8/31.
 */
public class Pacing {

    private static final Logger logger = LoggerFactory.getLogger(Pacing.class);

    public boolean checkParam()
    {
        return true;
    }

    public enum Status {
        ocpc_normal, dollmachine, automatch, autothrow, unkown;
    }

    public boolean pacing(AdInfo adInfo, CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo adClkInfo, StatInfo orientClkInfo, TimeInfo timeInfo)
    {
        boolean isGiveUp = false;
        boolean isWarn = false;

        Status stat = Status.unkown;

        if(adInfo.type.chargeType == 2 && adInfo.type.pid != 1 && adInfo.type.pid != 2)
        {
            stat = Status.ocpc_normal;
        }
        else if((adInfo.type.pid.intValue() & 2) > 0){
            stat = Status.dollmachine;
        }
        else if((adInfo.type.pid.intValue() & 4) > 0)
        {
            stat = Status.automatch;
        }

        switch (stat)
        {
            case ocpc_normal:
                Double  competence = competence(cvrInfo,ctrInfo,adClkInfo,timeInfo);
                Double priceScore = priceScore(adInfo.type.chargeType, adInfo.fee, adInfo.factor, adClkInfo,timeInfo);
                Double prob = competence * priceScore;
                double risk = risk(cvrInfo,ctrInfo,adClkInfo,timeInfo);
                boolean isRisk = Math.random() < risk ? true : false;

                if(!isRisk)
                {
                    isGiveUp = Math.random() > competence ? true : false;
                }
                if(!isGiveUp)
                {
                    isGiveUp = Math.random() > priceScore ? true : false;
                }

                if(Math.random()<0.0001 && isGiveUp)
                {
                    logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", adInfo.advertId, isGiveUp,competence,priceScore,risk);
                }
                else if(Math.random()<0.00001 && !isGiveUp)
                {
                    logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", adInfo.advertId, isGiveUp,competence,priceScore,risk);
                }
                break;
            case dollmachine:
                if(adInfo.advertId == 21357 || adInfo.advertId == 26159 || adInfo.advertId == 24230)
                {
                    double hourConvert = adClkInfo.g1h * cvrInfo.adCvrInfo.g1h;
                    double maxConvert = 4000;
                    if(adInfo.advertId == 21357)
                        maxConvert = 9000;
                    Calendar calendar = Calendar.getInstance();
                    int minutes = calendar.get(Calendar.MINUTE);
                    double speed = 0;
                    if(minutes > 0)
                    {
                        speed = hourConvert / minutes;
                        if(speed > 0.001) {
                            double p = (maxConvert *0.7) / (speed * 60);
                            p = p * p;
                            isGiveUp = Math.random() > p ? true : false;
                            if (hourConvert >= maxConvert) isGiveUp = true;
                        }
                    }
                    if(Math.random() < 0.0005)
                        logger.info("pacing advertId:{} convert:{} giveup:{} speed:{}", adInfo.advertId, hourConvert, isGiveUp, speed);
                }
                if(adInfo.advertId == 25504 || adInfo.advertId == 26537 || adInfo.advertId == 26466)
                {
                    double hourClk = adClkInfo.g1h;
                    double maxClk = 2500;
                    if(adInfo.advertId == 26537 || adInfo.advertId == 26466)
                    {
                        maxClk = 500;
                    }
                    Calendar calendar = Calendar.getInstance();
                    int minutes = calendar.get(Calendar.MINUTE);
                    double speed = 0;
                    if(minutes > 0)
                    {
                        speed = hourClk / minutes;
                        if(speed > 0.001) {
                            double p = (maxClk *0.7) / (speed * 60);
                            p = p * p;
                            isGiveUp = Math.random() > p ? true : false;
                            if (hourClk >= maxClk) isGiveUp = true;
                        }
                    }
                    if(Math.random() < 0.0005)
                        logger.info("pacing advertId:{} click:{} giveup:{} speed:{}", adInfo.advertId, hourClk, isGiveUp, speed);
                }
                if(adInfo.advertId == 25887)
                {
                    double hourClk = adClkInfo.g1h;
                    double maxClk = 260;
                    Calendar calendar = Calendar.getInstance();
                    int minutes = calendar.get(Calendar.MINUTE);
                    double speed = 0;
                    if(minutes > 0)
                    {
                        speed = hourClk / minutes;
                        if(speed > 0.001) {
                            double p = (maxClk *0.7) / (speed * 60);
                            p = p * p;
                            isGiveUp = Math.random() > p ? true : false;
                            if (hourClk >= maxClk) isGiveUp = true;
                        }
                    }
                    if(Math.random() < 0.0005)
                        logger.info("pacing advertId:{} click:{} giveup:{} speed:{}", adInfo.advertId, hourClk, isGiveUp, speed);
                }

                break;
            case automatch:
                boolean isTrace = cvrInfo.adCvrInfo.g7d > 0 ? true : false;
                isGiveUp = true;

                //出价偏置
                double fee1d = 0, clk1d = 0;
                for(double fee1h : timeInfo.hourFee)
                {
                    if(fee1h != -1) fee1d += fee1h;
                }
                for(double clk1h : timeInfo.hourClk)
                {
                    if(clk1d != -1) clk1d += clk1h;
                }
                double cpc = clk1d > 0 ? fee1d / clk1d : 0;
                double ratio = cpc > 0 ? adInfo.fee/cpc : 1;

                if(adInfo.type.chargeType == 1) {
                    ratio = Math.max(ratio, 1);
                    ratio = Math.min(ratio, 2);
                }

                if((adInfo.type.packageType & 2)>0) //转化有兴趣
                {
                    ratio = ratio * 0.8;
                }
                if((adInfo.type.packageType & 1)>0)
                {
                    ratio = ratio * 1.2;
                }

                if(isTrace) //17095  25216
                {
                    if(cvrInfo.cvr > ratio * cvrInfo.orientCvrInfo.g1d && adClkInfo.g1d * cvrInfo.adCvrInfo.g1d > 3)
                    {
                        isGiveUp = false;
                    }
                    else if(cvrInfo.cvr < 0.5 * ratio * cvrInfo.orientCvrInfo.g1d)
                    {
                        isGiveUp = true;
                    }
                }
                else
                {
                    if(cvrInfo.competerCvrInfo.app1d > 1.5 * ratio * cvrInfo.competerCvrInfo.g1d)
                    {
                        isGiveUp = false;
                    }
                }

                if(!isGiveUp)
                {
                    double dayConvert = adClkInfo.g1d * cvrInfo.orientCvrInfo.g1d;
                    if(Math.random() < 0.01)
                        logger.info("automatch advertId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} cpc:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{}", adInfo.advertId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, cpc, adInfo.fee,cvrInfo.cvr,cvrInfo.adCvrInfo.g1d,cvrInfo.competerCvrInfo.app1d,cvrInfo.competerCvrInfo.g1d,adInfo.type.packageType);
                }
                else
                {
                    double dayConvert = adClkInfo.g1d * cvrInfo.adCvrInfo.g1d;
                    if(Math.random() < 0.0001)
                        logger.info("automatch advertId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{}  cpc:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{}", adInfo.advertId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, cpc, adInfo.fee,cvrInfo.cvr,cvrInfo.adCvrInfo.g1d,cvrInfo.competerCvrInfo.app1d,cvrInfo.competerCvrInfo.g1d,adInfo.type.packageType);
                }
                break;
        }

        return isGiveUp;
    }

    public double wilsonRoofLeft(Double ratio, Double num)
    {
        if(ratio == null || num == null)
            return 0;
        long fenzi = (long) (ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio)
    {
        if(ratio == null || num == null)
            return 0;
        if(ratio == 0)
        {
            ratio = 0.00000001;
        }
        long fenmu = (long) (num/ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu)
    {
        if(fenzi == null || fenmu == null)
            return 0;
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi.longValue(), fenmu.longValue());
        return pair.lowerBound;
    }

    public double competence(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo)
    {
        double app7dCvr = wilsonRoofLeft(cvrInfo.adCvrInfo.app7d,clkInfo.app7d);
        double app1dCvr = wilsonRoofLeft(cvrInfo.adCvrInfo.app1d,clkInfo.app1d);
        double app1hCvr = wilsonRoofLeft(cvrInfo.adCvrInfo.app1h,clkInfo.app1h);
        double global7dCvr = wilsonRoofLeft(cvrInfo.adCvrInfo.g7d,clkInfo.g7d);
        double global1dCvr = wilsonRoofLeft(cvrInfo.adCvrInfo.g1d,clkInfo.g1d);
        double global1hCvr = wilsonRoofLeft(cvrInfo.adCvrInfo.g1h,clkInfo.g1h);
        double cvr = cvrInfo.cvr;
        double coefApp = 0.7 * Math.ceil(app7dCvr) + 0.21 * Math.ceil(app1dCvr) + 0.09 * Math.ceil(app1hCvr);
        double coefGlobal = 0.7 * Math.ceil(global7dCvr) + 0.21 * Math.ceil(global1dCvr) + 0.09 * Math.ceil(global1hCvr);
        double competenceApp =  coefApp > 0 ? coefApp * cvr / (0.7 * app7dCvr + 0.21 * app1dCvr + 0.09 * app1hCvr) : 1;
        double competenceGlobal = coefGlobal > 0 ? coefGlobal * cvr / (0.7 * global7dCvr + 0.21 * global1dCvr + 0.09 * global1hCvr) : 1;

        //System.out.println(competenceGlobal+"\t"+cvrInfo.cvrInfo.app1h+"\t"+app1hCvr);
        if((competenceGlobal < 0.3) || (competenceApp < 0.7 && competenceGlobal < 0.5))
        {
            return competenceGlobal;
        }

        return 1;
    }

    public double risk(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo)
    {
        double risk = 0;
        double arpuRisk;
        double costRisk;
        double app7dCtr = wilsonRoofRight(clkInfo.app7d,ctrInfo.adCtrInfo.app7d);
        double app1dCtr = wilsonRoofRight(clkInfo.app1d,ctrInfo.adCtrInfo.app1d);
        double app1hCtr = wilsonRoofRight(clkInfo.app1h,ctrInfo.adCtrInfo.app1h);
        double global7dCtr = wilsonRoofRight(clkInfo.g7d,ctrInfo.adCtrInfo.g7d);
        double global1dCtr = wilsonRoofRight(clkInfo.g1d,ctrInfo.adCtrInfo.g1d);
        double global1hCtr = wilsonRoofRight(clkInfo.g1h,ctrInfo.adCtrInfo.g1h);
        double ctr = ctrInfo.ctr;
        double coefApp = 0.7 * app7dCtr > 0 ? 1 : 0 + 0.21 * app1dCtr > 0 ? 1 : 0 + 0.09 * app1hCtr > 0 ? 1 : 0;
        double coefGlobal = 0.7 * global7dCtr > 0 ? 1 : 0 + 0.21 * global1dCtr > 0 ? 1 : 0 + 0.09 * global1hCtr > 0 ? 1 : 0;
        double competenceApp =  coefApp * ctr / (0.7 * app7dCtr + 0.21 * app1dCtr + 0.09 * app1hCtr);
        double competenceGlobal = coefGlobal * ctr / (0.7 * global7dCtr + 0.21 * global1dCtr + 0.09 * global1hCtr);
        if(competenceGlobal > 1)
        {
            risk = 1;
        }

        double budget = timeInfo.packageBudget;
        if(budget <= 0)
        {
            risk = 1;
        }

        return risk;
    }

    public double priceScore(int type , Long fee, Double factor, StatInfo clkInfo, TimeInfo timeInfo)
    {
        double confidence = 0;

        double fee1d = 0, clk1d = 0;
        for(double fee1h : timeInfo.hourFee)
        {
            if(fee1h != -1) fee1d += fee1h;
        }
        for(double clk1h : timeInfo.hourClk)
        {
            if(clk1d != -1) clk1d += clk1h;
        }
        double cpc = clk1d > 0 ? fee1d / clk1d : 50;

        if(cpc >= 20) {
            double feeOri = factor != 0 ? fee / factor : fee;
            if(fee <= 10)
            {
                return 0.1 * fee / 10;
            }
            else if((fee > 10 && fee<=15) && feeOri < 20)
            {
                return 0.5;
            }
        }

        return 1;
    }
}
