package cn.com.duiba.nezha.compute.common.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jiali on 2017/8/31.
 */
public class Pacing {

    public class StatInfo
    {
        double app1h;
        double app1d;
        double app7d;
        double g1h;
        double g1d;
        double g7d;

        public void setApp1d(double app1d) {
            this.app1d = app1d;
        }

        public void setApp1h(double app1h) {
            this.app1h = app1h;
        }

        public void setApp7d(double app7d) {
            this.app7d = app7d;
        }

        public void setG1d(double g1d) {
            this.g1d = g1d;
        }

        public void setG1h(double g1h) {
            this.g1h = g1h;
        }

        public void setG7d(double g7d) {
            this.g7d = g7d;
        }

        public double getApp1d() {
            return app1d;
        }

        public double getApp1h() {
            return app1h;
        }

        public double getApp7d() {
            return app7d;
        }

        public double getG1d() {
            return g1d;
        }

        public double getG1h() {
            return g1h;
        }

        public double getG7d() {
            return g7d;
        }
    }
    public class CvrInfo
    {
        double cvr; //融合值
        StatInfo cvrInfo;

        public void setCvr(double cvr) {
            this.cvr = cvr;
        }

        public void setCvrInfo(StatInfo cvrInfo) {
            this.cvrInfo = cvrInfo;
        }

        public double getCvr() {
            return cvr;
        }

        public StatInfo getCvrInfo() {
            return cvrInfo;
        }
    }

    public class CtrInfo
    {
        double ctr; //融合值
        StatInfo ctrInfo;

        public void setCtr(double ctr) {
            this.ctr = ctr;
        }

        public void setCtrInfo(StatInfo ctrInfo) {
            this.ctrInfo = ctrInfo;
        }

        public double getCtr() {
            return ctr;
        }

        public StatInfo getCtrInfo() {
            return ctrInfo;
        }
    }

    public class TimeInfo
    {
        List<Double> hourCtr;
        List<Double> hourCvr;
        List<Double> hourClk;
        List<Double> budgetFees; //如何取
        List<Double> budgetExps; //如何取

        public void setBudgetExps(List<Double> budgetExps) {
            this.budgetExps = budgetExps;
        }

        public void setBudgetFees(List<Double> budgetFees) {
            this.budgetFees = budgetFees;
        }

        public void setHourClk(List<Double> hourClk) {
            this.hourClk = hourClk;
        }

        public void setHourCtr(List<Double> hourCtr) {
            this.hourCtr = hourCtr;
        }

        public void setHourCvr(List<Double> hourCvr) {
            this.hourCvr = hourCvr;
        }

        public List<Double> getBudgetExps() {
            return budgetExps;
        }

        public List<Double> getBudgetFees() {
            return budgetFees;
        }

        public List<Double> getHourClk() {
            return hourClk;
        }

        public List<Double> getHourCtr() {
            return hourCtr;
        }

        public List<Double> getHourCvr() {
            return hourCvr;
        }
    }

    public boolean pacing(int  type, int fee, int bottomFee, int factor,
                          CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo)
    {
        double  competence = competence(cvrInfo,ctrInfo,clkInfo,timeInfo);
        double pricescore = priceScore(type,fee);
        double prob = competence * pricescore;
        boolean isGiveUp = Math.random() < prob ? true : false;
        return isGiveUp;
    }


    public double competence(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo)
    {
        double cvrConfidence = Math.min(clkInfo.app7d * cvrInfo.cvrInfo.app7d, 20);
        double appCvr = cvrInfo.cvrInfo.app7d;
        double globalCvr = cvrInfo.cvrInfo.g7d;
        double cvr = cvrInfo.cvr;
        if(cvr/appCvr < 0.5)
        {
            return 0;
        }
        if(cvr/globalCvr < 0.3)
        {
            return 0;
        }
        return 1;
    }

    public double priceScore(int type , int fee)
    {
        if(type == 1)
        {
            if(fee < 15)
                return 0;
        }
        return 1;
    }
}
