/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.support;

import cn.com.duiba.nezha.compute.api.dto.FeatureDto;
import cn.com.duiba.nezha.compute.common.enums.DateStyle;
import cn.com.duiba.nezha.compute.common.util.DateUtil;
import cn.com.duiba.nezha.compute.common.util.MyStringUtil2;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FeatureParse {
    public static boolean generateFeatureMapStatic(FeatureDto cf, Map<String, String> retMap) {
        boolean ret = false;
        try {
            if (cf != null) {
                cf.setCurrentGmtCreateTime(DateUtil.getCurrentTime(DateStyle.YYYY_MM_DD_HH_MM_SS));
                retMap.put("f108001", MyStringUtil2.Long2String(cf.getSlotId()));
                retMap.put("f109001", MyStringUtil2.Long2String(cf.getSlotType()));
                retMap.put("f201001", MyStringUtil2.Long2String(cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());
                retMap.put("f301001", MyStringUtil2.Long2String(cf.getOperatingActivityId()));
                retMap.put("f302001", MyStringUtil2.Long2String(cf.getActivityId()));
                retMap.put("f303001", MyStringUtil2.Long2String(cf.getActivityType()));
                retMap.put("f501001", cf.getUa());
                Integer hour = DateUtil.getHour(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS);
                retMap.put("f502001", MyStringUtil2.Integer2String(hour));
                Integer weekDay = DateUtil.getWeekNumber(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS);
                retMap.put("f502002", MyStringUtil2.Integer2String(weekDay));
                retMap.put("f503001", MyStringUtil2.Long2String(cf.getCityId()));
                retMap.put("f601001", MyStringUtil2.Long2String(FeatureParse.getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", MyStringUtil2.Long2String(FeatureParse.getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", MyStringUtil2.Long2String(FeatureParse.getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", MyStringUtil2.Long2String(FeatureParse.getRankLevel(cf.getActivityOrderRank())));
                Long orderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", MyStringUtil2.Long2String(orderGmtIntervelLevel));
                Long activityOrderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", MyStringUtil2.Long2String(activityOrderGmtIntervelLevel));
                Long activityLastChargeStatus = FeatureParse.getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", MyStringUtil2.Long2String(activityLastChargeStatus));
                Long lastChargeStatus = FeatureParse.getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", MyStringUtil2.Long2String(lastChargeStatus));
                Long activityChangeStatus = FeatureParse.getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", MyStringUtil2.Long2String(activityChangeStatus));
                retMap.put("f504001", cf.getModel());
                retMap.put("f505001", cf.getPriceSection());
                retMap.put("f506001", cf.getConnectionType());
                retMap.put("f507001", cf.getOperatorType());
                retMap.put("f611001", MyStringUtil2.Long2String(cf.getPutIndex()));
                retMap.put("f306001", cf.getActivityUseType());
                retMap.put("f403001", cf.getMemberId());
                retMap.put("f403005", cf.getMobile());
                Long iso = FeatureParse.isOld(cf.getUserLastlogbigintime(), cf.getUserRegtime());
                retMap.put("f403004", MyStringUtil2.Long2String(iso));
                retMap.put("f114001", cf.getSlotIndustryTagPid());
                retMap.put("f114002", cf.getSlotIndustryTagId());
                retMap.put("f205001", cf.getAppIndustryTagPid());
                retMap.put("f205002", cf.getAppIndustryTagId());
                retMap.put("f206001", cf.getTrafficTagPid());
                retMap.put("f206002", cf.getTrafficTagId());
                retMap.put("f9902", cf.getAppList2());
                retMap.put("f9906", cf.getCategoryIdList1());
                retMap.put("f9907", cf.getCategoryIdList2());
                retMap.put("f9908", cf.getIsGame());
                retMap.put("f508001", cf.getPhoneBrand());
                retMap.put("f508002", cf.getPhoneModelNum());
                retMap.put("f9914", cf.getImportantApp());
                retMap.put("f9915", cf.getClusterId());
                retMap.put("f9916", FeatureParse.getLevel("launch_pv", cf.getUIIds(), cf.getUILaunchPV()));
                retMap.put("f9917", FeatureParse.getLevel("click_pv", cf.getUIIds(), cf.getUIClickPv()));
                retMap.put("f9918", FeatureParse.getLevel("click_pv", cf.getUIIds(), cf.getUIEffectPv()));
                retMap.put("f9919", FeatureParse.getLevel("score", cf.getUIIds(), cf.getUIScore()));
                retMap.put("f9921", cf.getUICtr());
                retMap.put("f9922", cf.getUICvr());
                retMap.put("f9923", cf.getUUnICtr());
                retMap.put("f9924", cf.getUUnICvr());
                retMap.put("f404001", cf.getSex());
                retMap.put("f404002", cf.getAge());
                retMap.put("f404003", cf.getWorkStatus());
                retMap.put("f404004", cf.getStudentStatus());
                retMap.put("f404005", cf.getMarriageStatus());
                retMap.put("f404006", cf.getBear());
                retMap.put("f404007", cf.getInterestList());
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean generateFeatureMapDynamic(FeatureDto cf, Map<String, String> retMap) {
        boolean ret = false;
        try {
            if (cf != null) {
                FeatureParse.generateFeatureMapDynamic(cf, cf, retMap);
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean generateFeatureMapDynamic(FeatureDto cf, FeatureDto staticCf, Map<String, String> retMap) {
        boolean ret = false;
        try {
            if (cf != null) {
                retMap.put("f101001", MyStringUtil2.Long2String(cf.getAdvertId()));
                retMap.put("f106001", MyStringUtil2.Long2String(cf.getAccountId()));
                retMap.put("f111001", cf.getPromoteUrl());
                retMap.put("f102001", cf.getMatchTagNums());
                retMap.put("f801001", cf.getGoodsId());
                retMap.put("f802001", cf.getCatId());
                retMap.put("f802002", cf.getBrandId());
                retMap.put("f803001", MyStringUtil2.Long2String(FeatureParse.getCost(cf.getCost(), cf.getPrice())));
                retMap.put("f803002", MyStringUtil2.Long2String(FeatureParse.getLog(cf.getPrice())));
                retMap.put("f803003", MyStringUtil2.Long2String(FeatureParse.getCost(cf.getViewCount(), cf.getBuyCount())));
                retMap.put("f803004", MyStringUtil2.Long2String(FeatureParse.getLog(cf.getBuyCount())));
                retMap.put("f110001", MyStringUtil2.Long2String(cf.getTimes()));
                Long tagChangeStatus = FeatureParse.getLastTagChangeStatus(cf.getMatchTagNums(), cf.getDayLastMatchTagNums());
                retMap.put("f610001", MyStringUtil2.Long2String(tagChangeStatus));
                retMap.put("f104001", cf.getMaterialId());
                retMap.put("f112001", cf.getMaterialTags());
                retMap.put("f113001", cf.getAdvertTags());
                retMap.put("f804001", MyStringUtil2.Long2String(FeatureParse.getCtrIntervelLevel(cf.getAdvertCtr())));
                retMap.put("f804002", MyStringUtil2.Long2String(FeatureParse.getCvrIntervelLevel(cf.getAdvertCvr())));
                retMap.put("f805001", MyStringUtil2.Long2String(FeatureParse.getCtrIntervelLevel(cf.getAdvertAppCtr())));
                retMap.put("f805002", MyStringUtil2.Long2String(FeatureParse.getCvrIntervelLevel(cf.getAdvertAppCvr())));
                retMap.put("f806001", MyStringUtil2.Long2String(FeatureParse.getCtrIntervelLevel(cf.getAdvertSlotCtr())));
                retMap.put("f806002", MyStringUtil2.Long2String(FeatureParse.getCvrIntervelLevel(cf.getAdvertSlotCvr())));
                retMap.put("f807001", MyStringUtil2.Long2String(FeatureParse.getCtrIntervelLevel(cf.getAdvertActivityCtr())));
                retMap.put("f807002", MyStringUtil2.Long2String(FeatureParse.getCvrIntervelLevel(cf.getAdvertActivityCvr())));
                retMap.put("f9912", cf.getTradeId());
                retMap.put("f9913", cf.getTradeId2());
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static Map<String, String> getFeatureMap(FeatureDto cf) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            FeatureParse.generateFeatureMapStatic(cf, retMap);
            FeatureParse.generateFeatureMapDynamic(cf, retMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retMap;
    }

    public static Long getCtrIntervelLevel(Double ctr) {
        Long ret = null;
        ret = ctr == null ? Long.valueOf(-1L) : (ctr <= 0.999 ? Long.valueOf(Math.round(ctr * 100.0 / 3.0)) : Long.valueOf(-1L));
        return ret;
    }

    public static Long getCvrIntervelLevel(Double cvr) {
        Long ret = null;
        ret = cvr == null ? Long.valueOf(-1L) : (cvr <= 0.04 ? Long.valueOf(Math.round(cvr * 1000.0 / 4.0)) : (cvr <= 0.999 ? Long.valueOf(11L + Math.round((cvr - 0.04) * 100.0 / 3.0)) : Long.valueOf(-1L)));
        return ret;
    }

    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {
        Long ret = null;
        Integer minutes = DateUtil.getIntervalMinutes(date, otherDate, DateStyle.YYYY_MM_DD_HH_MM_SS, DateStyle.YYYY_MM_DD_HH_MM_SS);
        ret = minutes == null ? Long.valueOf(-1L) : (minutes <= 5 ? Long.valueOf(1L) : (minutes <= 10 ? Long.valueOf(2L) : (minutes <= 30 ? Long.valueOf(3L) : (minutes <= 60 ? Long.valueOf(4L) : Long.valueOf(99L)))));
        return ret;
    }

    public static Long getDayRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 7L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getRankLevel(Long rank) {
        Long ret = null;
        ret = rank <= 15L ? rank : Long.valueOf(-1L);
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {
        Long ret = null;
        ret = chargeNums == null || chargeNums < 1L ? Long.valueOf(0L) : Long.valueOf(1L);
        return ret;
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {
        Long ret = null;
        ret = operatingActivityId == null || lastOperatingActivityId == null ? Long.valueOf(0L) : (operatingActivityId.equals(lastOperatingActivityId) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {
        Long ret = null;
        ret = matchTagNums == null || lastMatchTagNums == null ? Long.valueOf(0L) : (matchTagNums.equals(lastMatchTagNums) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long ret = 0L;
        Integer dayIntervals = DateUtil.getIntervalDays(userLastlogbigintime, userRegtime);
        if (dayIntervals != null) {
            ret = dayIntervals > 1 ? 1L : 0L;
        }
        return ret;
    }

    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0L) {
            ret = new Double(Math.ceil(((double)price.longValue() + 1.0E-6) / (double)cost.longValue())).intValue();
        }
        return ret;
    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0L) {
            ret = new Double(Math.ceil(FeatureParse.log(lvalue.doubleValue(), 2 / 0))).intValue();
        }
        return ret;
    }

    public static String getLevel(String key, String idlist, String valueList) {
        String[] valueArr;
        String s = "";
        if (idlist == null || valueList == null || idlist.isEmpty() || valueList.isEmpty()) {
            return null;
        }
        String[] idArr = idlist.split(",");
        if (idArr.length != (valueArr = valueList.split(",")).length) {
            return null;
        }
        for (int i = 0; i < idArr.length; ++i) {
            int value = 0;
            try {
                value = Integer.parseInt(valueArr[i]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            catch (NullPointerException e) {
                continue;
            }
            s = s + idArr[i] + "&" + String.valueOf(FeatureParse.discretization(key, value)) + ",";
        }
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int discretization(String key, int value) {
        int class_id = 0;
        switch (key) {
            case "launch_pv": {
                if (value > -100000000 & value <= 0) {
                    class_id = 1;
                    break;
                }
                if (value > 0 & value <= 1) {
                    class_id = 2;
                    break;
                }
                if (value > 1 & value <= 2) {
                    class_id = 3;
                    break;
                }
                if (value > 2 & value <= 3) {
                    class_id = 4;
                    break;
                }
                if (value > 3 & value <= 4) {
                    class_id = 5;
                    break;
                }
                if (value > 4 & value <= 5) {
                    class_id = 6;
                    break;
                }
                if (value > 5 & value <= 6) {
                    class_id = 7;
                    break;
                }
                if (value > 6 & value <= 7) {
                    class_id = 8;
                    break;
                }
                if (value > 7 & value <= 18) {
                    class_id = 9;
                    break;
                }
                if (value > 18 & value <= 50) {
                    class_id = 10;
                    break;
                }
                if (value > 50 & value <= 150) {
                    class_id = 11;
                    break;
                }
                if (value > 150 & value <= 300) {
                    class_id = 12;
                    break;
                }
                class_id = 13;
                break;
            }
            case "click_pv": {
                if (value > -100000000 & value <= 0) {
                    class_id = 1;
                    break;
                }
                if (value > 0 & value <= 1) {
                    class_id = 2;
                    break;
                }
                if (value > 2 & value <= 3) {
                    class_id = 3;
                    break;
                }
                if (value > 3 & value <= 4) {
                    class_id = 4;
                    break;
                }
                if (value > 4 & value <= 5) {
                    class_id = 5;
                    break;
                }
                if (value > 5 & value <= 6) {
                    class_id = 6;
                    break;
                }
                if (value > 6 & value <= 8) {
                    class_id = 7;
                    break;
                }
                if (value > 8 & value <= 15) {
                    class_id = 8;
                    break;
                }
                if (value > 15 & value <= 80) {
                    class_id = 9;
                    break;
                }
                if (value > 80 & value <= 225) {
                    class_id = 10;
                    break;
                }
                class_id = 11;
                break;
            }
            case "effect_pv": {
                if (value > -100000000 & value <= 0) {
                    class_id = 1;
                    break;
                }
                if (value > 0 & value <= 1) {
                    class_id = 2;
                    break;
                }
                if (value > 1 & value <= 2) {
                    class_id = 3;
                    break;
                }
                if (value > 2 & value <= 3) {
                    class_id = 4;
                    break;
                }
                if (value > 4 & (double)value <= 15.0) {
                    class_id = 5;
                    break;
                }
                if ((double)value > 15.0 & value <= 25) {
                    class_id = 6;
                    break;
                }
                if ((double)value > 25.0 & value <= 70) {
                    class_id = 7;
                    break;
                }
                if (value > 70 & value <= 150) {
                    class_id = 8;
                    break;
                }
                if (value > 150 & value <= 225) {
                    class_id = 9;
                    break;
                }
                class_id = 10;
                break;
            }
            case "score": {
                class_id = value > -100000000 & value <= -471 ? 1 : (value > -471 & value <= -331 ? 2 : (value > -331 & value <= -168 ? 3 : (value > -168 & value <= -52 ? 4 : (value > -52 & value <= -19 ? 5 : (value > -19 & value <= -8 ? 6 : (value > -8 & value <= -4 ? 7 : (value > -4 & value <= 1 ? 8 : (value > 1 & value <= 2 ? 9 : (value > 2 & value <= 17 ? 10 : (value > 17 & value <= 42 ? 11 : (value > 42 & value <= 73 ? 12 : (value > 73 & value <= 126 ? 13 : (value > 126 & value <= 284 ? 14 : 15)))))))))))));
            }
        }
        return class_id;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }
}

