/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.pacing;

import cn.com.duiba.nezha.compute.common.model.pacing.AdInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.AutoMatchInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.CtrInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.CvrInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.StatInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.TimeInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.pacing.WilsonPair;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pacing {
    private static final Logger logger = LoggerFactory.getLogger(Pacing.class);

    public boolean checkParam() {
        return true;
    }

    public boolean pacing(AdInfo adInfo, CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo adClkInfo, StatInfo orientClkInfo, TimeInfo timeInfo) {
        boolean isGiveUp = false;
        Status stat = Status.unkown;
        if (adInfo.type.chargeType == 2 && (adInfo.type.pid & 2) == 0 && (adInfo.type.pid & 4) == 0) {
            stat = Status.ocpc_normal;
        } else if (adInfo.type.chargeType == 1 && (adInfo.type.pid & 2) == 0 && (adInfo.type.pid & 4) == 0) {
            stat = Status.cpc_normal;
        } else if ((adInfo.type.pid & 2) > 0) {
            stat = Status.dollmachine;
        } else if ((adInfo.type.pid & 4) > 0) {
            stat = Status.automatch;
        }
        double fee1d = 0.0;
        double clk1d = 0.0;
        for (double fee1h : timeInfo.hourFee) {
            if (fee1h == -1.0) continue;
            fee1d += fee1h;
        }
        for (double clk1h : timeInfo.hourClk) {
            if (clk1d == -1.0) continue;
            clk1d += clk1h;
        }
        long tag = 0L;
        switch (stat) {
            case ocpc_normal: {
                boolean isRisk;
                Double competence = this.competence(cvrInfo, ctrInfo, adClkInfo, timeInfo);
                Double priceScore = this.priceScore(adInfo.type.chargeType, adInfo.fee, adInfo.factor, adClkInfo, timeInfo);
                Double prob = competence * priceScore;
                double risk = this.risk(cvrInfo, ctrInfo, adClkInfo, timeInfo);
                boolean bl = isRisk = Math.random() < risk;
                if (!isRisk) {
                    boolean bl2 = isGiveUp = Math.random() > competence;
                }
                if (!isGiveUp) {
                    boolean bl3 = isGiveUp = Math.random() > priceScore;
                }
                if (isGiveUp) {
                    // empty if block
                }
                if (adInfo.quailityLevel >= 1 && adInfo.quailityLevel <= 3 && Math.random() < 0.001 && isGiveUp) {
                    logger.info("blacklist advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{adInfo.advertId, isGiveUp, competence, priceScore, risk});
                }
                if (Math.random() < 1.0E-4 && isGiveUp) {
                    logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{adInfo.advertId, isGiveUp, competence, priceScore, risk});
                    break;
                }
                if (!(Math.random() < 1.0E-5) || isGiveUp) break;
                logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{adInfo.advertId, isGiveUp, competence, priceScore, risk});
                break;
            }
            case cpc_normal: {
                if (orientClkInfo.g1d == null || cvrInfo.orientCvrInfo.g1d == null || !adInfo.autoMatchInfo.enable.booleanValue()) break;
                double dayConvert = orientClkInfo.g1d * cvrInfo.orientCvrInfo.g1d;
                if (adInfo.type.chargeType == 1 && cvrInfo.cvr < 0.1 * cvrInfo.orientCvrInfo.g1d && dayConvert > 3.0 && Math.random() < 1.0E-4) {
                    logger.info("automatch advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} ctr:{}", new Object[]{adInfo.advertId, adInfo.orientId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, adInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, ctrInfo.ctr});
                }
                if (adInfo.quailityLevel < 1 || adInfo.quailityLevel > 3 || !(Math.random() < 0.001)) break;
                logger.info("automatch blacklist advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} ctr:{}", new Object[]{adInfo.advertId, adInfo.orientId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, adInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, ctrInfo.ctr});
                break;
            }
            case dollmachine: {
                double maxClk;
                double hourClk;
                double p;
                double speed;
                int minutes;
                Calendar calendar;
                if (adInfo.advertId == 21357L || adInfo.advertId == 26159L || adInfo.advertId == 24230L) {
                    double hourConvert = adClkInfo.g1h * cvrInfo.adCvrInfo.g1h;
                    double maxConvert = 4000.0;
                    if (adInfo.advertId == 21357L) {
                        maxConvert = 11000.0;
                    }
                    calendar = Calendar.getInstance();
                    minutes = calendar.get(12);
                    speed = 0.0;
                    if (minutes > 0 && (speed = hourConvert / (double)minutes) > 0.001) {
                        p = maxConvert * 0.7 / (speed * 60.0);
                        p *= p;
                        boolean bl = isGiveUp = Math.random() > p;
                        if (hourConvert >= maxConvert) {
                            isGiveUp = true;
                        }
                    }
                    if (Math.random() < 5.0E-4) {
                        logger.info("pacing advertId:{} convert:{} giveup:{} speed:{}", new Object[]{adInfo.advertId, hourConvert, isGiveUp, speed});
                    }
                }
                if (adInfo.advertId == 25504L || adInfo.advertId == 26537L || adInfo.advertId == 26466L) {
                    hourClk = adClkInfo.g1h;
                    maxClk = 2500.0;
                    if (adInfo.advertId == 26537L || adInfo.advertId == 26466L) {
                        maxClk = 500.0;
                    }
                    calendar = Calendar.getInstance();
                    minutes = calendar.get(12);
                    speed = 0.0;
                    if (minutes > 0 && (speed = hourClk / (double)minutes) > 0.001) {
                        p = maxClk * 0.7 / (speed * 60.0);
                        p *= p;
                        boolean bl = isGiveUp = Math.random() > p;
                        if (hourClk >= maxClk) {
                            isGiveUp = true;
                        }
                    }
                    if (Math.random() < 5.0E-4) {
                        logger.info("pacing advertId:{} click:{} giveup:{} speed:{}", new Object[]{adInfo.advertId, hourClk, isGiveUp, speed});
                    }
                }
                if (adInfo.advertId != 25887L) break;
                hourClk = adClkInfo.g1h;
                maxClk = 260.0;
                calendar = Calendar.getInstance();
                minutes = calendar.get(12);
                speed = 0.0;
                if (minutes > 0 && (speed = hourClk / (double)minutes) > 0.001) {
                    p = maxClk * 0.7 / (speed * 60.0);
                    p *= p;
                    boolean bl = isGiveUp = Math.random() > p;
                    if (hourClk >= maxClk) {
                        isGiveUp = true;
                    }
                }
                if (!(Math.random() < 5.0E-4)) break;
                logger.info("pacing advertId:{} click:{} giveup:{} speed:{}", new Object[]{adInfo.advertId, hourClk, isGiveUp, speed});
                break;
            }
            case automatch: {
                boolean isTrace = this.isTrace(cvrInfo);
                isGiveUp = true;
                if (!adInfo.autoMatchInfo.enable.booleanValue()) {
                    isGiveUp = true;
                    break;
                }
                Calendar c = Calendar.getInstance();
                int hour = c.get(11);
                long time = (long)Math.pow(2.0, hour);
                Long period = adInfo.autoMatchInfo.enablePeriod;
                if (period != null && (time & period) == 0L) {
                    isGiveUp = true;
                    break;
                }
                double ratio = this.convertPackage(adInfo, 1.0, 0.8);
                double dayConvert = orientClkInfo.g1d * cvrInfo.orientCvrInfo.g1d;
                double convertCost = adInfo.autoMatchInfo.convertCost != null ? (double)adInfo.autoMatchInfo.convertCost.longValue() : 1.0E7;
                double realConvertCost = dayConvert > 0.0 ? adInfo.orientCost / dayConvert : adInfo.orientCost;
                double fac = 1.0;
                if (adInfo.type.chargeType == 2 && dayConvert > 1.0) {
                    convertCost = Math.min((double)adInfo.target.longValue(), convertCost);
                    fac = convertCost > 0.0 ? realConvertCost / convertCost : 1.0;
                    if ((fac = Math.max(fac, adInfo.factor > 0.0 ? 1.0 / adInfo.factor : 1.0)) > 1.0) {
                        ratio = ratio * fac * fac;
                    }
                } else if (adInfo.type.chargeType == 1 && dayConvert > 1.0) {
                    double d = fac = convertCost > 0.0 ? realConvertCost / convertCost : 1.0;
                    if (fac > 1.0) {
                        ratio *= fac;
                    }
                    if (fac > 2.0) {
                        ratio = 2.0 * ratio;
                    }
                }
                if (isTrace) {
                    if (cvrInfo.cvr > 1.3 * ratio * cvrInfo.orientCvrInfo.g1d && dayConvert > 3.0) {
                        if (adInfo.type.chargeType == 2 && fac < 1.4) {
                            isGiveUp = false;
                            tag = 2L;
                        }
                        if (adInfo.type.chargeType == 1) {
                            isGiveUp = false;
                            tag = 2L;
                        }
                    } else if (adInfo.type.chargeType == 1 && cvrInfo.cvr < 0.5 * ratio * cvrInfo.orientCvrInfo.g1d && dayConvert > 3.0) {
                        isGiveUp = true;
                    }
                    if (adInfo.quailityLevel >= 1 && adInfo.quailityLevel <= 3) {
                        isGiveUp = true;
                    }
                    if (adInfo.type.chargeType == 1) {
                        if (realConvertCost > 1.3 * convertCost && adInfo.orientCost > 5.0 * convertCost) {
                            logger.info("automatch fusing advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} fac:{} chargeType:{} factor:{}", new Object[]{adInfo.advertId, adInfo.orientId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, adInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, convertCost, fac, adInfo.type.chargeType, adInfo.factor});
                            isGiveUp = true;
                        }
                    } else {
                        convertCost = Math.min((double)adInfo.target.longValue(), convertCost);
                        if (realConvertCost > 1.3 * convertCost && adInfo.orientCost > 5.0 * convertCost) {
                            adInfo.autoMatchInfo.enable = false;
                            logger.info("automatch fusing advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} fac:{} chargeType:{} factor:{}", new Object[]{adInfo.advertId, adInfo.orientId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, adInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, convertCost, fac, adInfo.type.chargeType, adInfo.factor});
                            isGiveUp = true;
                        }
                    }
                    if (adInfo.quailityLevel == 16) {
                        adInfo.autoMatchInfo.enable = false;
                        logger.info("automatch fusing advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} fac:{} chargeType:{} factor:{}", new Object[]{adInfo.advertId, adInfo.orientId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, adInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, convertCost, fac, adInfo.type.chargeType, adInfo.factor});
                    }
                } else if (cvrInfo.competerCvrInfo.app1d > 1.5 * cvrInfo.competerCvrInfo.g1d && adInfo.orientCost > convertCost) {
                    tag = 2L;
                    isGiveUp = false;
                }
                if (isGiveUp || !(Math.random() < 0.01)) break;
                logger.info("automatch advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} fac:{} chargeType:{} factor:{}", new Object[]{adInfo.advertId, adInfo.orientId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, adInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, convertCost, fac, adInfo.type.chargeType, adInfo.factor});
            }
        }
        AutoMatchInfo.EffectLog effectLog = adInfo.autoMatchInfo.new AutoMatchInfo.EffectLog();
        effectLog.tag = tag;
        adInfo.autoMatchInfo.effectLog = effectLog;
        return isGiveUp;
    }

    public boolean isTrace(CvrInfo cvrInfo) {
        return cvrInfo.adCvrInfo.g7d > 0.0;
    }

    public double convertPackage(AdInfo adInfo, double ratio, double zoomCoef) {
        if ((adInfo.type.packageType & 2) > 0) {
            ratio *= zoomCoef;
        }
        if ((adInfo.type.packageType & 1) > 0) {
            double d = ratio = zoomCoef > 0.0 ? ratio / zoomCoef : 1.2;
        }
        if (adInfo.quailityLevel == 8) {
            ratio *= zoomCoef;
        }
        return ratio;
    }

    public double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    public double competence(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        double competenceGlobal;
        double app7dCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.app7d, clkInfo.app7d);
        double app1dCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.app1d, clkInfo.app1d);
        double app1hCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.app1h, clkInfo.app1h);
        double global7dCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.g7d, clkInfo.g7d);
        double global1dCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.g1d, clkInfo.g1d);
        double global1hCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.g1h, clkInfo.g1h);
        double cvr = cvrInfo.cvr;
        double coefApp = 0.7 * Math.ceil(app7dCvr) + 0.21 * Math.ceil(app1dCvr) + 0.09 * Math.ceil(app1hCvr);
        double coefGlobal = 0.7 * Math.ceil(global7dCvr) + 0.21 * Math.ceil(global1dCvr) + 0.09 * Math.ceil(global1hCvr);
        double competenceApp = coefApp > 0.0 ? coefApp * cvr / (0.7 * app7dCvr + 0.21 * app1dCvr + 0.09 * app1hCvr) : 1.0;
        double d = competenceGlobal = coefGlobal > 0.0 ? coefGlobal * cvr / (0.7 * global7dCvr + 0.21 * global1dCvr + 0.09 * global1hCvr) : 1.0;
        if (competenceGlobal < 0.3 || competenceApp < 0.7 && competenceGlobal < 0.5) {
            return competenceGlobal;
        }
        return 1.0;
    }

    public double risk(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        double budget;
        double coefApp;
        double risk = 0.0;
        double app7dCtr = this.wilsonRoofRight(clkInfo.app7d, ctrInfo.adCtrInfo.app7d);
        double app1dCtr = this.wilsonRoofRight(clkInfo.app1d, ctrInfo.adCtrInfo.app1d);
        double app1hCtr = this.wilsonRoofRight(clkInfo.app1h, ctrInfo.adCtrInfo.app1h);
        double global7dCtr = this.wilsonRoofRight(clkInfo.g7d, ctrInfo.adCtrInfo.g7d);
        double global1dCtr = this.wilsonRoofRight(clkInfo.g1d, ctrInfo.adCtrInfo.g1d);
        double global1hCtr = this.wilsonRoofRight(clkInfo.g1h, ctrInfo.adCtrInfo.g1h);
        double ctr = ctrInfo.ctr;
        double d = 0.7 * app7dCtr > 0.0 ? 1.0 : (0.0 + 0.21 * app1dCtr > 0.0 ? 1.0 : (coefApp = 0.0 + 0.09 * app1hCtr > 0.0 ? 1.0 : 0.0));
        double coefGlobal = 0.7 * global7dCtr > 0.0 ? 1.0 : (0.0 + 0.21 * global1dCtr > 0.0 ? 1.0 : (0.0 + 0.09 * global1hCtr > 0.0 ? 1.0 : 0.0));
        double competenceApp = coefApp * ctr / (0.7 * app7dCtr + 0.21 * app1dCtr + 0.09 * app1hCtr);
        double competenceGlobal = coefGlobal * ctr / (0.7 * global7dCtr + 0.21 * global1dCtr + 0.09 * global1hCtr);
        if (competenceGlobal > 1.0) {
            risk = 1.0;
        }
        if ((budget = timeInfo.packageBudget.doubleValue()) <= 0.0) {
            risk = 1.0;
        }
        return risk;
    }

    public double priceScore(int type, Long fee, Double factor, StatInfo clkInfo, TimeInfo timeInfo) {
        double cpc;
        double confidence = 0.0;
        double fee1d = 0.0;
        double clk1d = 0.0;
        for (double fee1h : timeInfo.hourFee) {
            if (fee1h == -1.0) continue;
            fee1d += fee1h;
        }
        for (double clk1h : timeInfo.hourClk) {
            if (clk1d == -1.0) continue;
            clk1d += clk1h;
        }
        double d = cpc = clk1d > 0.0 ? fee1d / clk1d : 50.0;
        if (cpc >= 20.0) {
            double feeOri;
            double d2 = feeOri = factor != 0.0 ? (double)fee.longValue() / factor : (double)fee.longValue();
            if (fee <= 10L) {
                return 0.1 * (double)fee.longValue() / 10.0;
            }
            if (fee > 10L && fee <= 15L && feeOri < 20.0) {
                return 0.5;
            }
        }
        return 1.0;
    }

    public static enum Status {
        ocpc_normal,
        cpc_normal,
        dollmachine,
        automatch,
        autothrow,
        unkown;

    }
}

