package cn.com.duiba.nezha.compute.common.model.pacing;

import java.util.*;

public class SlotRecommender {
    public static Map<Boolean, Collection<Long>> recommend(List<OrientInfo> orientlist, List<BlackInfo> blacklist) {

        List<Long> allAdvertIds = new ArrayList<>();
        for (OrientInfo orientInfo : orientlist) {
            allAdvertIds.add(orientInfo.getAdvertId());
        }
        Set<Long> OrientSet = new HashSet<Long>();

        for (OrientInfo orient : orientlist) {
            //boolean isManagered = orient.isManagered; //是否为托管配置
            Integer chargeType = orient.chargeType;  //计费方式
            Long target = orient.target;  //目标成本
            Long fee = orient.fee; //出价
            Double cvr = orient.cvr;
            Double confidence = orient.confidence;   //置信度
            Double bias = orient.bias;

            Random r = new Random();
            Double x = r.nextDouble();
            Double p_convert_cost = fee / cvr;


            //////////ocpc
            if (chargeType == 2) {
                //剔除有发券的预估偏差较高定向
                if (bias < 3 && confidence > 0) {
                    OrientSet.add(orient.advertId);

                    // 无发券，使用行业-广告位或广告维度偏差<2，定向几率0.6 (这里的偏差=0，代表空值)
                } else if (bias < 2 && bias != 0 && confidence == 0 && x > 0.4) {
                    OrientSet.add(orient.advertId);

                    //无发券，使用行业-广告位或广告维度偏差>2，定向几率0.2
                } else if (bias >= 2 && confidence == 0 && x > 0.8) {
                    OrientSet.add(orient.advertId);

                    //无发券，偏差为空，定向几率0.2
                } else {
                    if (x > 0.8) {
                        OrientSet.add(orient.advertId);
                    }
                }
            }

            ////////cpc
            else if (chargeType == 1) {
                if (confidence > 0 && p_convert_cost < 2 * target) {
                    OrientSet.add(orient.advertId);
                }
                if (confidence == 0 && bias != 0 && p_convert_cost < 0.8 * target && x > 0.4) {
                    OrientSet.add(orient.advertId);
                }
                if (confidence == 0 && bias == 0 && p_convert_cost < 0.8 * target && x > 0.5) {
                    OrientSet.add(orient.advertId);
                }
            }

        }


        Set<Long> BlackSet = new HashSet<Long>();
        for (BlackInfo black : blacklist) {
            BlackSet.add(black.advertId);
        }


        //剔除黑名单
        OrientSet.removeAll(BlackSet);
        allAdvertIds.removeAll(OrientSet);

        Map<Boolean, Collection<Long>> resultMap = new HashMap<>();
        resultMap.put(true, OrientSet);
        resultMap.put(false, allAdvertIds);


        return resultMap;
    }
}
