/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.pacing;

import cn.com.duiba.nezha.compute.common.model.pacing.AdInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.AutoMatchInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.CtrInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.CvrInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.StatInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.TimeInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.pacing.WilsonPair;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pacing {
    private static final Logger logger = LoggerFactory.getLogger(Pacing.class);

    public boolean checkParam() {
        return true;
    }

    public boolean pacing(AdInfo adInfo, CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo adClkInfo, StatInfo orientClkInfo, TimeInfo timeInfo) {
        boolean isGiveUp = false;
        Status stat = Status.unkown;
        if (adInfo.type.chargeType == 2 && (adInfo.type.pid & 2) == 0 && (adInfo.type.pid & 4) == 0) {
            stat = Status.ocpc_normal;
        } else if (adInfo.type.chargeType == 1 && (adInfo.type.pid & 2) == 0 && (adInfo.type.pid & 4) == 0) {
            stat = Status.cpc_normal;
        } else if ((adInfo.type.pid & 2) > 0) {
            stat = Status.dollmachine;
        } else if ((adInfo.type.pid & 4) > 0) {
            stat = Status.automatch;
        }
        double fee1d = 0.0;
        double clk1d = 0.0;
        for (double fee1h : timeInfo.hourFee) {
            if (fee1h == -1.0) continue;
            fee1d += fee1h;
        }
        for (double clk1h : timeInfo.hourClk) {
            if (clk1d == -1.0) continue;
            clk1d += clk1h;
        }
        long tag = 0L;
        switch (stat) {
            case ocpc_normal: {
                boolean isRisk;
                Double competence = this.competence(cvrInfo, ctrInfo, adClkInfo, timeInfo);
                Double priceScore = this.priceScore(adInfo.type.chargeType, adInfo.orientInfo.fee, adInfo.factor, adClkInfo, timeInfo);
                Double prob = competence * priceScore;
                double risk = this.risk(cvrInfo, ctrInfo, adClkInfo, timeInfo);
                boolean bl = isRisk = Math.random() < risk;
                if (!isRisk) {
                    boolean bl2 = isGiveUp = Math.random() > competence;
                }
                if (!isGiveUp) {
                    boolean bl3 = isGiveUp = Math.random() > priceScore;
                }
                if (isGiveUp) {
                    // empty if block
                }
                if (adInfo.quailityLevel >= 1 && adInfo.quailityLevel <= 3 && Math.random() < 0.001 && isGiveUp) {
                    logger.info("blacklist advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{adInfo.advertId, isGiveUp, competence, priceScore, risk});
                }
                if (Math.random() < 1.0E-4 && isGiveUp) {
                    logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{adInfo.advertId, isGiveUp, competence, priceScore, risk});
                    break;
                }
                if (!(Math.random() < 1.0E-5) || isGiveUp) break;
                logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{adInfo.advertId, isGiveUp, competence, priceScore, risk});
                break;
            }
            case cpc_normal: {
                if (orientClkInfo.g1d == null || cvrInfo.orientCvrInfo.g1d == null || !adInfo.autoMatchInfo.enable.booleanValue()) break;
                double dayConvert = orientClkInfo.g1d * cvrInfo.orientCvrInfo.g1d;
                if (adInfo.type.chargeType == 1 && cvrInfo.cvr < 0.1 * cvrInfo.orientCvrInfo.g1d && dayConvert > 3.0 && Math.random() < 1.0E-4) {
                    logger.info("automatch advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} ctr:{}", new Object[]{adInfo.advertId, adInfo.orientInfo.orientId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, adInfo.orientInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, ctrInfo.ctr});
                }
                if (adInfo.quailityLevel < 1 || adInfo.quailityLevel > 3 || !(Math.random() < 0.001)) break;
                logger.info("automatch blacklist advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} ctr:{}", new Object[]{adInfo.advertId, adInfo.orientInfo.orientId, adInfo.appId, isGiveUp, dayConvert, fee1d, clk1d, adInfo.orientInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, ctrInfo.ctr});
                break;
            }
            case dollmachine: {
                isGiveUp = true;
                break;
            }
            case automatch: {
                double amBiasCoef;
                boolean isTrace = this.isTrace(cvrInfo);
                isGiveUp = true;
                if (!adInfo.autoMatchInfo.enable.booleanValue()) {
                    isGiveUp = true;
                    break;
                }
                Calendar c = Calendar.getInstance();
                int hour = c.get(11);
                long time = (long)Math.pow(2.0, hour);
                Long period = adInfo.autoMatchInfo.enablePeriod;
                if (period != null && (time & period) == 0L) {
                    isGiveUp = true;
                    break;
                }
                double mixDayConvert = orientClkInfo.g1d * cvrInfo.orientCvrInfo.g1d;
                double mixConvertCost = mixDayConvert > 0.0 ? adInfo.orientCost / mixDayConvert : adInfo.orientCost;
                double origDayConvert = mixDayConvert - (double)adInfo.autoMatchInfo.convert.longValue() > 0.0 ? mixDayConvert - (double)adInfo.autoMatchInfo.convert.longValue() : 0.0;
                double origConvertCost = origDayConvert > 0.0 ? (adInfo.orientCost - (double)adInfo.autoMatchInfo.cost.longValue()) / origDayConvert : adInfo.orientCost - (double)adInfo.autoMatchInfo.cost.longValue();
                double amConvertCost = adInfo.autoMatchInfo.convert > 0L ? (double)(adInfo.autoMatchInfo.cost / adInfo.autoMatchInfo.convert) : (double)adInfo.autoMatchInfo.cost.longValue();
                double target = adInfo.autoMatchInfo.convertCost != null ? (double)adInfo.autoMatchInfo.convertCost.longValue() : -1.0;
                target = adInfo.orientInfo.target > 0L ? (double)adInfo.orientInfo.target.longValue() : target;
                double ratio = this.convertPackage(adInfo, 1.0, 0.8);
                ratio *= this.peerScore(cvrInfo);
                double biasCoef = 1.0;
                double mixBiasCoef = target > 0.0 && (mixDayConvert > 3.0 || adInfo.orientCost > 5.0 * target) ? mixConvertCost / target : 1.0;
                double d = amBiasCoef = target > 0.0 && (adInfo.autoMatchInfo.convert > 3L || (double)adInfo.autoMatchInfo.cost.longValue() > 3.0 * target) ? amConvertCost / target : 1.0;
                if (adInfo.type.chargeType == 2) {
                    if (amBiasCoef > 1.0 && mixBiasCoef > 1.0) {
                        biasCoef = amBiasCoef;
                    }
                    if (mixBiasCoef == 1.0 || amBiasCoef == 1.0) {
                        biasCoef = adInfo.factor;
                    }
                    if (biasCoef > 1.0) {
                        ratio *= biasCoef;
                    }
                    if (biasCoef > 1.3) {
                        ratio *= Math.pow(biasCoef, 2.0);
                    }
                } else if (adInfo.type.chargeType == 1) {
                    if (amBiasCoef > 1.0 && mixBiasCoef > 1.0) {
                        biasCoef = amBiasCoef;
                    }
                    if (target < 0.0) {
                        ratio = 1.2 * ratio;
                    }
                    ratio = 1.3 * ratio;
                    if (biasCoef > 1.0) {
                        ratio *= biasCoef;
                    }
                    if (biasCoef > 2.0) {
                        ratio = 2.0 * ratio;
                    }
                }
                if (isTrace) {
                    if (cvrInfo.cvr > ratio * cvrInfo.orientCvrInfo.g1d && mixDayConvert > 2.0) {
                        if (adInfo.type.chargeType == 2) {
                            isGiveUp = false;
                            tag = 2L;
                        }
                        if (adInfo.type.chargeType == 1) {
                            isGiveUp = false;
                            tag = 2L;
                        }
                    }
                    if (adInfo.autoMatchInfo.convertCost == null && cvrInfo.cvr > 5.0 * ratio * cvrInfo.orientCvrInfo.g1d && cvrInfo.competerCvrInfo.g1d > 2.0 * ratio * cvrInfo.orientCvrInfo.g1d) {
                        isGiveUp = true;
                    }
                    if (adInfo.quailityLevel >= 1 && adInfo.quailityLevel <= 3) {
                        isGiveUp = true;
                    }
                    double productCoef = 1.0;
                    if (adInfo.orientInfo.isManagered || adInfo.orientInfo.chargeType == 2) {
                        productCoef = 0.9;
                    }
                    if (adInfo.type.chargeType == 1) {
                        if (target > 0.0 && amConvertCost > 1.3 * productCoef * target && (double)adInfo.autoMatchInfo.cost.longValue() > 3.0 * target) {
                            if (Math.random() < 0.01) {
                                logger.info("automatch fusing advertId:{} orientId:{} appid:{} giveup:{} cost:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} biasCoef:{} chargeType:{} factor:{} amCost:{} amConvert:{}", new Object[]{adInfo.advertId, adInfo.orientInfo.orientId, adInfo.appId, isGiveUp, mixConvertCost, mixDayConvert, fee1d, clk1d, adInfo.orientInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, target, biasCoef, adInfo.type.chargeType, adInfo.factor, adInfo.autoMatchInfo.cost, adInfo.autoMatchInfo.convert});
                            }
                            isGiveUp = true;
                        }
                        if (target < 0.0 && origConvertCost > 0.0 && amConvertCost > 1.3 * origConvertCost) {
                            if (Math.random() < 0.01) {
                                logger.info("automatch fusing advertId:{} orientId:{} appid:{} giveup:{} cost:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} biasCoef:{} chargeType:{} factor:{} amCost:{} amConvert:{}", new Object[]{adInfo.advertId, adInfo.orientInfo.orientId, adInfo.appId, isGiveUp, mixConvertCost, mixDayConvert, fee1d, clk1d, adInfo.orientInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, target, biasCoef, adInfo.type.chargeType, adInfo.factor, adInfo.autoMatchInfo.cost, adInfo.autoMatchInfo.convert});
                            }
                            isGiveUp = true;
                        }
                    } else if (target > 0.0 && amConvertCost > 1.3 * productCoef * target && mixConvertCost > target && (double)adInfo.autoMatchInfo.cost.longValue() > 3.0 * target) {
                        if (Math.random() < 0.01) {
                            logger.info("automatch fusing advertId:{} orientId:{} appid:{} giveup:{} cost:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} biasCoef:{} chargeType:{} factor:{} amCost:{} amConvert:{}", new Object[]{adInfo.advertId, adInfo.orientInfo.orientId, adInfo.appId, isGiveUp, mixConvertCost, mixDayConvert, fee1d, clk1d, adInfo.orientInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, target, biasCoef, adInfo.type.chargeType, adInfo.factor, adInfo.autoMatchInfo.cost, adInfo.autoMatchInfo.convert});
                        }
                        isGiveUp = true;
                    }
                    if (adInfo.quailityLevel == 16) {
                        logger.info("automatch fusing advertId:{} orientId:{} appid:{} giveup:{} cost:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} biasCoef:{} chargeType:{} factor:{} amCost:{} amConvert:{}", new Object[]{adInfo.advertId, adInfo.orientInfo.orientId, adInfo.appId, isGiveUp, mixConvertCost, mixDayConvert, fee1d, clk1d, adInfo.orientInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, target, biasCoef, adInfo.type.chargeType, adInfo.factor, adInfo.autoMatchInfo.cost, adInfo.autoMatchInfo.convert});
                    }
                } else if (cvrInfo.competerCvrInfo.app1d > 1.5 * cvrInfo.competerCvrInfo.g1d && adInfo.orientCost > target) {
                    tag = 2L;
                    isGiveUp = false;
                }
                if (isGiveUp || !(Math.random() < 0.001)) break;
                logger.info("automatch advertId:{} orientId:{} appid:{} giveup:{} convert:{} fee1d:{} clk1d:{} fee:{} cvr:{} gcvr:{} ccvr:{} cgcvr:{} pack:{} quality:{} convertCost:{} biasCoef:{} chargeType:{} factor:{} amCost:{} amConvert:{}", new Object[]{adInfo.advertId, adInfo.orientInfo.orientId, adInfo.appId, isGiveUp, mixDayConvert, fee1d, clk1d, adInfo.orientInfo.fee, cvrInfo.cvr, cvrInfo.orientCvrInfo.g1d, cvrInfo.competerCvrInfo.app1d, cvrInfo.competerCvrInfo.g1d, adInfo.type.packageType, adInfo.quailityLevel, target, biasCoef, adInfo.type.chargeType, adInfo.factor, adInfo.autoMatchInfo.cost, adInfo.autoMatchInfo.convert});
            }
        }
        AutoMatchInfo.EffectLog effectLog = adInfo.autoMatchInfo.new AutoMatchInfo.EffectLog();
        effectLog.tag = tag;
        adInfo.autoMatchInfo.effectLog = effectLog;
        return isGiveUp;
    }

    public boolean isTrace(CvrInfo cvrInfo) {
        return cvrInfo.adCvrInfo.g7d > 0.0;
    }

    public double convertPackage(AdInfo adInfo, double ratio, double zoomCoef) {
        if ((adInfo.type.packageType & 2) > 0) {
            ratio *= zoomCoef;
        }
        if ((adInfo.type.packageType & 1) > 0) {
            double d = ratio = zoomCoef > 0.0 ? ratio / zoomCoef : 1.2;
        }
        if (adInfo.quailityLevel == 8) {
            ratio *= zoomCoef;
        }
        return ratio;
    }

    public double peerScore(CvrInfo cvrInfo) {
        double peerScore = cvrInfo.competerCvrInfo.g1d > 0.0 && cvrInfo.competerCvrInfo.app1d > 0.0 ? cvrInfo.competerCvrInfo.g1d / cvrInfo.competerCvrInfo.app1d : 1.0;
        peerScore = Math.max(peerScore, 0.8);
        peerScore = Math.min(peerScore, 1.2);
        return peerScore;
    }

    public double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    public double competence(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        double competenceGlobal;
        double app7dCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.app7d, clkInfo.app7d);
        double app1dCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.app1d, clkInfo.app1d);
        double app1hCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.app1h, clkInfo.app1h);
        double global7dCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.g7d, clkInfo.g7d);
        double global1dCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.g1d, clkInfo.g1d);
        double global1hCvr = this.wilsonRoofLeft(cvrInfo.adCvrInfo.g1h, clkInfo.g1h);
        double cvr = cvrInfo.cvr;
        double coefApp = 0.7 * Math.ceil(app7dCvr) + 0.21 * Math.ceil(app1dCvr) + 0.09 * Math.ceil(app1hCvr);
        double coefGlobal = 0.7 * Math.ceil(global7dCvr) + 0.21 * Math.ceil(global1dCvr) + 0.09 * Math.ceil(global1hCvr);
        double competenceApp = coefApp > 0.0 ? coefApp * cvr / (0.7 * app7dCvr + 0.21 * app1dCvr + 0.09 * app1hCvr) : 1.0;
        double d = competenceGlobal = coefGlobal > 0.0 ? coefGlobal * cvr / (0.7 * global7dCvr + 0.21 * global1dCvr + 0.09 * global1hCvr) : 1.0;
        if (competenceGlobal < 0.3 || competenceApp < 0.7 && competenceGlobal < 0.5) {
            return competenceGlobal;
        }
        return 1.0;
    }

    public double risk(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        double budget;
        double coefApp;
        double risk = 0.0;
        double app7dCtr = this.wilsonRoofRight(clkInfo.app7d, ctrInfo.adCtrInfo.app7d);
        double app1dCtr = this.wilsonRoofRight(clkInfo.app1d, ctrInfo.adCtrInfo.app1d);
        double app1hCtr = this.wilsonRoofRight(clkInfo.app1h, ctrInfo.adCtrInfo.app1h);
        double global7dCtr = this.wilsonRoofRight(clkInfo.g7d, ctrInfo.adCtrInfo.g7d);
        double global1dCtr = this.wilsonRoofRight(clkInfo.g1d, ctrInfo.adCtrInfo.g1d);
        double global1hCtr = this.wilsonRoofRight(clkInfo.g1h, ctrInfo.adCtrInfo.g1h);
        double ctr = ctrInfo.ctr;
        double d = 0.7 * app7dCtr > 0.0 ? 1.0 : (0.0 + 0.21 * app1dCtr > 0.0 ? 1.0 : (coefApp = 0.0 + 0.09 * app1hCtr > 0.0 ? 1.0 : 0.0));
        double coefGlobal = 0.7 * global7dCtr > 0.0 ? 1.0 : (0.0 + 0.21 * global1dCtr > 0.0 ? 1.0 : (0.0 + 0.09 * global1hCtr > 0.0 ? 1.0 : 0.0));
        double competenceApp = coefApp * ctr / (0.7 * app7dCtr + 0.21 * app1dCtr + 0.09 * app1hCtr);
        double competenceGlobal = coefGlobal * ctr / (0.7 * global7dCtr + 0.21 * global1dCtr + 0.09 * global1hCtr);
        if (competenceGlobal > 1.0) {
            risk = 1.0;
        }
        if ((budget = timeInfo.packageBudget.doubleValue()) <= 0.0) {
            risk = 1.0;
        }
        return risk;
    }

    public double priceScore(int type, Long fee, Double factor, StatInfo clkInfo, TimeInfo timeInfo) {
        double cpc;
        double confidence = 0.0;
        double fee1d = 0.0;
        double clk1d = 0.0;
        for (double fee1h : timeInfo.hourFee) {
            if (fee1h == -1.0) continue;
            fee1d += fee1h;
        }
        for (double clk1h : timeInfo.hourClk) {
            if (clk1d == -1.0) continue;
            clk1d += clk1h;
        }
        double d = cpc = clk1d > 0.0 ? fee1d / clk1d : 50.0;
        if (cpc >= 20.0) {
            double feeOri;
            double d2 = feeOri = factor != 0.0 ? (double)fee.longValue() / factor : (double)fee.longValue();
            if (fee <= 10L) {
                return 0.1 * (double)fee.longValue() / 10.0;
            }
            if (fee > 10L && fee <= 15L && feeOri < 20.0) {
                return 0.5;
            }
        }
        return 1.0;
    }

    public static enum Status {
        ocpc_normal,
        cpc_normal,
        dollmachine,
        automatch,
        autothrow,
        unkown;

    }
}

