/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.pacing;

import cn.com.duiba.nezha.compute.common.model.pacing.AdvertOrientInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.OrientInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

public class SlotRecommender {
    public static Map<Boolean, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Collection<AdvertOrientInfo> blacklist) {
        HashSet<AdvertOrientInfo> orientSet = new HashSet<AdvertOrientInfo>();
        for (OrientInfo orientInfo : orientlist) {
            double biasThreshold;
            double orientRatio;
            Integer chargeType = orientInfo.chargeType;
            Long target = orientInfo.target;
            Long fee = orientInfo.fee;
            Double cvr = orientInfo.cvr;
            Double confidence = orientInfo.confidence;
            Double bias = orientInfo.bias;
            Double orientCostG1d = orientInfo.orientCostG1d;
            Double orientClkG1d = orientInfo.orientClkG1d;
            Double orientCvrG1d = orientInfo.orientCvrG1d;
            Double orientConvert = orientClkG1d * orientCvrG1d;
            Double orientCostConvert = orientConvert != 0.0 ? orientCostG1d / orientConvert : (double)target.longValue();
            Double orientCostConvertbias = orientCostConvert / (double)target.longValue();
            Random r = new Random();
            Double x = r.nextDouble();
            if (chargeType == 2 && cvr != null) {
                double biasRatio = 0.8 / orientCostConvertbias;
                orientRatio = 0.5 / orientCostConvertbias;
                biasThreshold = (4.0 - (1.0 - confidence) * 2.0) * biasRatio;
                if (confidence > 1.0 && bias <= 4.0) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                }
                if (confidence > 0.0 && confidence <= 1.0 && bias > 0.0 && bias <= biasThreshold) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                }
                if (confidence == 0.0 && bias >= 0.0 && bias <= biasThreshold && cvr >= 0.05 && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                }
                if (confidence == 0.0 && bias >= 0.0 && bias <= biasThreshold && cvr < 0.05 && x < 0.5 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                }
                if (confidence != 0.0 || !(bias > biasThreshold) || !(cvr > 0.05) || !(x < 0.2 * orientRatio)) continue;
                orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                continue;
            }
            if (chargeType != 1 || cvr == null || cvr == 0.0) continue;
            double targetRatio = 0.8 / orientCostConvertbias;
            orientRatio = 0.01 / orientCostConvertbias;
            biasThreshold = (4.0 - (1.0 - confidence) * 2.0) * targetRatio;
            Double p_convert_cost = cvr != 0.0 ? (double)fee.longValue() / cvr : 0.0;
            if (confidence > 1.0 && p_convert_cost < (double)(4L * target)) {
                orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            }
            if (confidence > 0.0 && confidence <= 1.0 && p_convert_cost < biasThreshold * (double)target.longValue()) {
                orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            }
            if (confidence == 0.0 && bias != 0.0 && p_convert_cost < 0.8 * (double)target.longValue() && x < 1.0 * orientRatio) {
                orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            }
            if (confidence != 0.0 || bias != 0.0 || !(p_convert_cost < 0.8 * (double)target.longValue()) || !(x < 0.6 * orientRatio)) continue;
            orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }
        HashSet<AdvertOrientInfo> orientPackageList = new HashSet<AdvertOrientInfo>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }
        orientSet.removeAll(blacklist);
        orientPackageList.removeAll(orientSet);
        HashMap<Boolean, Collection<AdvertOrientInfo>> hashMap = new HashMap<Boolean, Collection<AdvertOrientInfo>>();
        hashMap.put(true, orientSet);
        hashMap.put(false, orientPackageList);
        return hashMap;
    }
}

