package cn.com.duiba.nezha.compute.common.model.pacing;

import java.util.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static cn.com.duiba.nezha.compute.common.model.feedback.FeedBack.autoManageFeedBack;


public class SlotRecommender {

    private static final Logger logger = LoggerFactory.getLogger(SlotRecommender.class);

    public static Map<ResultType, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Long slotId, TrusteeshipParams trusteeshipParams) {

        Set<AdvertOrientInfo> orientSet = new HashSet<>();
        Set<AdvertOrientInfo> fuseSet1 = new HashSet<>();
        Set<AdvertOrientInfo> fuseSet2 = new HashSet<>();
        Set<AdvertOrientInfo> recommendListSet = new HashSet<>();
        Set<AdvertOrientInfo> shieldListSet = new HashSet<>();

        TrusteeshipParams.SlotRecommendParams slotRecommendParams = trusteeshipParams.getSlotRecommendParams();
        Double startFactor=slotRecommendParams.getStartFactor();
        Double cpaBiasRatioFactor=slotRecommendParams.getCpaBiasRatioFactor();
        Double cpaOrientRatioFactor=slotRecommendParams.getCpaOrientRatioFactor();
        Double cpaBiasThresholdFactor=slotRecommendParams.getCpaBiasThresholdFactor();
        Double cpcTargetRatioFactor=slotRecommendParams.getCpcTargetRatioFactor();
        Double cpcOrientRatioFactor=slotRecommendParams.getCpcOrientRatioFactor();
        Double cpcBiasThresholdFactor=slotRecommendParams.getCpcBiasThresholdFactor();

        TrusteeshipParams.FeedBackParams feedBackParams=trusteeshipParams.getFeedBackParams();
        if (Math.random()<0.0001) {
            logger.info("params slotRecommendParams:{},feedBackParams:{}", slotRecommendParams,feedBackParams);
        }

        for (OrientInfo orient : orientlist) {
            //boolean isManagered = orient.isManagered; //是否为托管配置
            Integer manageType=orient.manageType;//系统托管方式 //自动模式：2  优投模式：3
            Integer chargeType = orient.chargeType;  //计费方式
            Long target = orient.target!=0?orient.target:1;  //目标成本
            Long fee = orient.fee; //出价
            Double appOrientCvrDay=orient.appOrientCvrDay!=null ? orient.appOrientCvrDay : 0;

            List<Double> priceSectionList=orient.priceSection==null?new ArrayList<Double>():orient.priceSection;
            List<Double> cvrList=orient.cvrSet==null?new ArrayList<Double>():orient.cvrSet;
            List<Double> confidenceList=orient.confidenceSet==null?new ArrayList<Double>():orient.confidenceSet;
            List<Double> biasList=orient.biasSet==null?new ArrayList<Double>():orient.biasSet;

            if (Math.random()<0.001 && !confidenceList.isEmpty()) {
                logger.info("OrientInfo OrientInfo:{}", orient);
            }

            Map<String,Double> candidateMap=new HashMap<String,Double>();
            if (chargeType == 2 && priceSectionList.size()==2 && confidenceList.size()==3 && biasList.size()==3) {
                if(appOrientCvrDay*target>priceSectionList.get(1)) {
                    candidateMap.put("confidence", confidenceList.get(2));
                    candidateMap.put("bias", biasList.get(2));
                }else if(appOrientCvrDay*target>priceSectionList.get(0)){
                    candidateMap.put("confidence", confidenceList.get(1));
                    candidateMap.put("bias", biasList.get(1));
                }else{
                    candidateMap.put("confidence", confidenceList.get(0));
                    candidateMap.put("bias", biasList.get(0));
                }
            } else if (chargeType == 1 && priceSectionList.size()==2 && confidenceList.size()==3 && cvrList.size()==3) {
                if (fee>priceSectionList.get(1)) {
                    candidateMap.put("confidence",confidenceList.get(2));
                    candidateMap.put("cvr",cvrList.get(2));
                } else if (fee>priceSectionList.get(0)) {
                    candidateMap.put("confidence",confidenceList.get(1));
                    candidateMap.put("cvr",cvrList.get(1));
                } else {
                    candidateMap.put("confidence",confidenceList.get(0));
                    candidateMap.put("cvr",cvrList.get(0));
                }
            }

            Double orientCostG1d = orient.orientCostG1d != null ? orient.orientCostG1d : 0.0;             //配置消耗
            Double orientCostG7d = orient.orientCostG7d != null ? orient.orientCostG7d : 0.0;             //配置消耗

            Double orientConvert = orient.orientConvertG1d;
            Double orientCostConvert = (orientConvert != 0 && orientCostG1d != 0) ? orientCostG1d / orientConvert : target;       //配置当天实际成本
            Double orientCostConvertbias = (orientConvert != 0) ? orientCostConvert / target : orientCostG1d / target;        //配置当天实际成本与目标成本偏差
            Double orientConfidence = orientCostG1d/(target*5);

            Double slotOrientationCost=orient.slotOrientationCost!=null?orient.slotOrientationCost:0.0;          //广告位+配置粒度消耗
            Double slotOrientationConvert=orient.slotOrientationConvert!=null?orient.slotOrientationConvert:0.0;   //广告位+配置粒度转化量
            Double slotOrientationConfidence=slotOrientationCost/(target*5);  //广告位+配置粒度置信度
            Double slotOrientationCostConvert=(slotOrientationCost!=0 && slotOrientationConvert!=0)?slotOrientationCost/slotOrientationConvert:target;  //广告位+配置粒度实时成本
            Double slotOrientationCostConvertBias=(slotOrientationConvert!=0) ? slotOrientationCostConvert / target : slotOrientationCost / target;

            Random r = new Random();
            Double x = r.nextDouble();
            double p_convert_cost = 0.0;
            double biasRatio = 0.0;
            double biasThreshold = 0.0;
            double orientRatio = 0.0;
            double targetRatio = 0.0;
            double startRatio = (orientCostG7d < 5 * target) ? startFactor : 1; //启动时减缓消耗速度控制因子

            String feedBackLabel=autoManageFeedBack(orient,feedBackParams);
            if (!"".equals(feedBackLabel) && Math.random()<0.02) {
                logger.info("slot_blackset slotId:{},advertId:{},orientId:{},feedBackLabel:{}", slotId,orient.advertId,orient.orientId,feedBackLabel);
            }

            //熔断开关

            Boolean isFuse="fuse1".equals(feedBackLabel) || "fuse2".equals(feedBackLabel);
            if ("fuse1".equals(feedBackLabel)){fuseSet1.add(new AdvertOrientInfo(orient.advertId,orient.orientId));}
            else if ("fuse2".equals(feedBackLabel)){fuseSet2.add(new AdvertOrientInfo(orient.advertId,orient.orientId));}

            Double confidence=candidateMap.get("confidence");
            Double cvr=candidateMap.get("cvr");
            Double bias=candidateMap.get("bias");
            //////////ocpc
            if (chargeType == 2 && !isFuse) {

                //选配置
                biasRatio = (orientCostConvertbias!=0)?cpaBiasRatioFactor/(orientCostConvertbias * orientCostConvertbias):cpaBiasRatioFactor;
                orientRatio = (orientCostConvertbias!=0)?cpaOrientRatioFactor/(orientCostConvertbias * orientCostConvertbias * orientCostConvertbias):cpaOrientRatioFactor;
                orientRatio=(orientCostConvertbias>1.7)?0:orientRatio;
                biasThreshold = Math.max((cpaBiasThresholdFactor*confidence+1) * biasRatio * startRatio,1);

                //有历史数据
                if (confidence > 0 && bias>0 && bias <= biasThreshold) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    if (manageType==3) {recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}
                }

                //无历史数据，离线控制候选集数量，线上控制定向概率和反馈黑白名单，成本偏差太大定向概率为0
                if (confidence == 0  &&  x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    if (manageType==3) {recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}
                }

            }

            ////////cpc
            else if (chargeType == 1  && !isFuse) {

                //选配置
                targetRatio = (orientCostConvertbias!=0)?cpcTargetRatioFactor/(orientCostConvertbias * orientCostConvertbias):cpcTargetRatioFactor;
                orientRatio = (orientCostConvertbias!=0)?cpcOrientRatioFactor/(orientCostConvertbias * orientCostConvertbias * orientCostConvertbias):cpcOrientRatioFactor;
                orientRatio=(orientCostConvertbias>1.5)?0:orientRatio;
                biasThreshold = Math.max((cpcBiasThresholdFactor*confidence+1) * biasRatio * startRatio,cpcBiasThresholdFactor);
                p_convert_cost = (cvr!=0)?fee / cvr:1000000.0;

                //广告维度历史数据
                if (confidence > 0 && p_convert_cost <= biasThreshold * target) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    if (manageType==3) {recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}

                }

                //无数据
                if (confidence == 0 && p_convert_cost < biasThreshold * target && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    if (manageType==3) {recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}

                }

            }

            //根据正负反馈进行删减
            if ("w".equals(feedBackLabel)){
                orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                if (manageType==3) {recommendListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}
            }
            if ("b".equals(feedBackLabel)){
                orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                if (manageType==2) {shieldListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}
            }
            if ("b".equals(feedBackLabel)){
                orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                if (manageType==2) {shieldListSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId,slotOrientationCostConvertBias,slotOrientationCost));}
            }

        }

        Set<AdvertOrientInfo> orientPackageList = new HashSet<>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }

        orientPackageList.removeAll(orientSet);
        orientPackageList.removeAll(shieldListSet);//黑名单不用传给智能匹配

        Map<ResultType, Collection<AdvertOrientInfo>> map = new HashMap<>();
        map.put(ResultType.ONTARGET, orientSet);
        map.put(ResultType.GIVEUP, orientPackageList);
        map.put(ResultType.FUSE1, fuseSet1);
        map.put(ResultType.FUSE2, fuseSet2);
        map.put(ResultType.ORIENT, recommendListSet);
        map.put(ResultType.SHIELD, shieldListSet);

        if (Math.random()<0.002) {
            logger.info("ResultType ResultType:{}", map);
        }

        return map;
    }
}
