package cn.com.duiba.nezha.compute.common.model.feedback;

import cn.com.duiba.nezha.compute.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.TrusteeshipParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedBack {

    private static final Logger logger = LoggerFactory.getLogger(FeedBack.class);

    public static String autoManageFeedBack(OrientInfo orient,TrusteeshipParams.FeedBackParams feedBackparams) {
        Long target=orient.getTarget()!=0?orient.getTarget():1;
        Double orientCostG1d = orient.getOrientCostG1d() != null ? orient.getOrientCostG1d() : 0.0;             //配置消耗
        Double orientConvert = orient.getOrientConvertG1d();
        Double orientConfidence = orientCostG1d/(target*5);
        Double orientCostConvert = (orientConvert != 0 && orientCostG1d != 0) ? orientCostG1d / orientConvert : target;       //配置当天实际成本
        Double orientCostConvertbias = (orientConvert != 0) ? orientCostConvert / target : orientCostG1d / target;        //配置当天实际成本与目标成本偏差

        Double slotOrientationCost=orient.getSlotOrientationCost()!=null?orient.getSlotOrientationCost():0.0;          //广告位+配置粒度消耗
        Double slotOrientationConvert=orient.getSlotOrientationConvert()!=null?orient.getSlotOrientationConvert():0.0;   //广告位+配置粒度转化量
        Double slotOrientationConfidence=slotOrientationCost/(target*5);  //广告位+配置粒度置信度
        Double slotOrientationCostConvert=(slotOrientationCost!=0 && slotOrientationConvert!=0)?slotOrientationCost/slotOrientationConvert:target;  //广告位+配置粒度实时成本
        Double slotOrientationCostConvertBias=(slotOrientationConvert!=0) ? slotOrientationCostConvert / target : slotOrientationCost / target;

        //熔断
        String label="";
        if (orientCostG1d>5*target && orientConvert==0) {
            label="fuse1";
        } else if (orientCostG1d>feedBackparams.getFuseOrientCostG1dFactor() && orientCostConvertbias>feedBackparams.getFuseOrientCostConvertBiasFactor()) {
            label="fuse2";
        } else {
            //黑白名单
            //根据广告位+配置粒度
            if (slotOrientationConfidence >=feedBackparams.getwSlotOrientationConfidenceFactor()  && slotOrientationCostConvertBias <= Math.max(feedBackparams.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                label = "w";
            }
            if (orientConfidence >= feedBackparams.getbOrientConfidenceFactor1() && orientCostConvertbias > feedBackparams.getbOrientCostConvertBiasFactor1() && slotOrientationConfidence >= feedBackparams.getbSlotOrientationConfidenceFactor1() && slotOrientationCostConvertBias > feedBackparams.getbSlotOrientationCostConvertBiasFactor1() / (orientCostConvertbias * orientCostConvertbias)) {
                label = "b";
            }
            if (orientConfidence >= feedBackparams.getbOrientConfidenceFactor2() && orientCostConvertbias > feedBackparams.getbOrientCostConvertBiasFactor2() && slotOrientationConfidence < feedBackparams.getbSlotOrientationConfidenceFactor2() && Math.random() > feedBackparams.getbSlotOrientRadioFactor2() * slotOrientationConfidence / (orientCostConvertbias * slotOrientationCostConvertBias)) {
                label = "b";
            }
        }

        return label;
    }
}
