package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.api.dto.CorrectionInfo;
import cn.com.duiba.nezha.compute.api.dto.NezhaStatDto;
import cn.com.duiba.nezha.compute.common.util.AssertUtil;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * Created by pc on 2017/9/12.
 */
public class ModelPredRectifier {
    private static Logger logger = Logger.getLogger(ModelPredRectifier.class);

    public static void getCorrectionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {

        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            setCorrectionFactor(info);
        }


    }

    public static void getCorrectionReconstructionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {


        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            setCorrectionReconstructionFactor(info);
        }

    }


    public static void setCorrectionFactor(CorrectionInfo info) throws Exception {

        if (info == null) {
            logger.warn("setCorrectionFactor input invalid,with info = null");
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }


        // 1 调节因子赋默认值
        info.setCorrectionFactor(1.0);
        info.setReconstructionFactor(1.0);


    }

    public static void setCorrectionReconstructionFactor(CorrectionInfo info) throws Exception {

        if (AssertUtil.isEmpty(info)) {
            return;
        }
        // 1 调节因子赋默认值
        info.setCorrectionFactor(1.0);
        info.setReconstructionFactor(1.0);

    }

}
