package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.api.dto.CorrectionInfo;
import cn.com.duiba.nezha.compute.api.dto.NezhaStatDto;
import cn.com.duiba.nezha.compute.common.util.AssertUtil;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * Created by pc on 2017/9/12.
 */
public class ModelPredRectifier2 {
    private static Logger logger = Logger.getLogger(ModelPredRectifier2.class);

    public static void getCorrectionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {

        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            setCorrectionFactor(info);
        }


    }

    public static void getCorrectionReconstructionFactor(List<CorrectionInfo> advertCorrectionInfoList) throws Exception {


        if (AssertUtil.isEmpty(advertCorrectionInfoList)) {
            return;
        }
        for (CorrectionInfo info : advertCorrectionInfoList) {
            setCorrectionReconstructionFactor(info);
        }

    }


    public static void setCorrectionFactor(CorrectionInfo info) throws Exception {

        if (info == null) {
            logger.warn("setCorrectionFactor input invalid,with info = null");
            return;
        }
        if (info.getNezhaStatDto() == null) {
            return;
        }


        // 1 调节因子赋默认值
        info.setCorrectionFactor(1.0);
        info.setReconstructionFactor(1.0);

        // 2 解析
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();

//        private String id;
//        private Long algType;
//        private Long advertId;
//        private Long appId;
//        private Long ctrLaunchCnt;
//        private Long cvrLaunchCnt;
//        private Double preCtrAcc;
//        private Double preCvrAcc;
//        private Double preCtrAvg;
//        private Double preCvrAvg;
//
//        private Double statCtrAcc;
//        private Double statCvrAcc;
//        private Double statCtrAvg;
//        private Double statCvrAvg;


        // 3


        Double newCurrentPreValue = currentPreValue;

        if (currentPreValue < 0.001) {
            newCurrentPreValue = 0.0001;
        }


    }

    public static void setCorrectionReconstructionFactor(CorrectionInfo info) throws Exception {

        if (AssertUtil.isEmpty(info)) {
            return;
        }
        // 1 调节因子赋默认值
        info.setCorrectionFactor(1.0);
        info.setReconstructionFactor(1.0);

        // 2 判断调节类型
        Long type = info.getType();
        Double currentPreValue = info.getCurrentPreValue();
        NezhaStatDto nezhaStatDto = info.getNezhaStatDto();

    }


    /**
     * 结果平滑,限定调节范围
     *
     * @param point
     * @param upperLimit
     * @param lowerLimit
     * @return
     * @throws Exception
     */
    public static Double noiseSmoother(Double point, Double upperLimit, Double lowerLimit) throws Exception {
        Double ret = point;

        if (AssertUtil.isAnyEmpty(upperLimit, lowerLimit)) {
            logger.warn("noiseSmoother input invalid,with upperLimit=" + upperLimit + ",lowerLimit=" + lowerLimit);
            return ret;
        }

        if (point != null) {
            ret = point > upperLimit ? upperLimit : (point < lowerLimit ? lowerLimit : point);
        }

        return ret;
    }


    public static Double correctionValue(Double currentPreValue, Double avgPreValue, Double avgFeedbackValue, Double upperLimit, Double lowerLimit) throws Exception {
        Double ret = currentPreValue;

        if (AssertUtil.isAnyEmpty(currentPreValue, avgPreValue, avgFeedbackValue)) {
            return ret;
        }

        if (currentPreValue > 0.0 && avgPreValue > 0.0 && avgFeedbackValue > 0.0) {
            // 对数正太分布,同方差假设,调整
            Double lndValue = noiseSmoother(currentPreValue * avgFeedbackValue / avgPreValue, upperLimit, lowerLimit);

            // 正太分布,同方差,调整
            Double ndValue = noiseSmoother(currentPreValue + avgFeedbackValue - avgPreValue, upperLimit, lowerLimit);

//            if()

        }

        return ret;
    }

}
