/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.activityselect;

import cn.com.duiba.nezha.compute.common.model.activityselect.ActivityInfo;
import cn.com.duiba.nezha.compute.common.model.activityselect.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitySelector {
    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int)(c1.score - c2.score);
        }
    };

    public static List<ActivityInfo> match(List<ActivityInfo> activityInfos, int topn) {
        ArrayList<ActivityInfo> result = new ArrayList<ActivityInfo>();
        ArrayList<ActivityInfo> newActs = new ArrayList<ActivityInfo>();
        ArrayList oldActs = new ArrayList();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(7, iComparator);
        boolean rankLevel = false;
        double matchscore = 0.0;
        for (ActivityInfo activity : activityInfos) {
            if (activity.request.globalVal < 100.0) {
                if (!(Math.random() < 0.01)) continue;
                newActs.add(activity);
                continue;
            }
            double globalRpm = ActivitySelector.wilsonRoofLeft(activity.send.globalVal, activity.request.globalVal + activity.send.globalVal);
            double slotRpm = ActivitySelector.wilsonRoofLeft(activity.send.slotVal, activity.request.slotVal + activity.send.slotVal);
            double appRpm = ActivitySelector.wilsonRoofLeft(activity.send.appVal, activity.request.appVal + activity.send.appVal);
            double rpm = Math.max(globalRpm, slotRpm);
            rpm = Math.max(slotRpm, appRpm);
            MatchInfo info = new MatchInfo();
            info.act = activity;
            info.score = rpm;
            candis.add(info);
        }
        for (int i = 0; i < topn; ++i) {
            result.add(((MatchInfo)candis.poll()).act);
        }
        return result;
    }

    public static ActivityInfo select(List<ActivityInfo> activityInfos) {
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        double decay = Constant.DECAY;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = 0.01;
        double maxH = 0.01;
        activityInfos = ActivitySelector.match(activityInfos, 100);
        for (ActivityInfo act : activityInfos) {
            double hrpm;
            double grpm;
            double exposure = act.request.slotVal;
            double click = act.click.slotVal;
            if (act.hisClick.globalVal > 500.0 || act.updateTime > 60000L) {
                act.hisClick.slotVal += click;
                act.hisRequest.slotVal += exposure;
            }
            RankInfo info = mMap.containsKey(act.activityId) ? (RankInfo)mMap.get(act.activityId) : new RankInfo();
            info.grpm = grpm = act.hisSend.globalVal / act.hisRequest.globalVal;
            info.gexp = act.hisRequest.globalVal;
            maxG = Math.max(grpm, maxG);
            info.hrpm = hrpm = act.hisSend.slotVal / act.hisRequest.slotVal;
            info.hexp = act.hisRequest.slotVal;
            mMap.put(act.activityId, info);
            if (!(info.hexp > 50.0)) continue;
            maxH = Math.max(hrpm, maxH);
        }
        ArrayList<ActivityInfo> candiList = new ArrayList<ActivityInfo>();
        for (ActivityInfo act : activityInfos) {
            if (act.request.globalVal > 0.0) {
                double reward = Constant.MIN_REWARD;
                double confidence = act.hisClick.slotVal > 500.0 ? 1.0 : act.hisClick.slotVal / 500.0;
                reward = (1.0 - confidence) * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).grpm, maxG, 0.5) + confidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).hrpm, maxH, 0.5);
                reward = Math.max(reward, Constant.MIN_REWARD);
                if (act.count < 20.0) {
                    act.count = 20.0;
                    act.reward = Math.min(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).grpm * 0.5 * act.count / maxG, 0.5 * act.count);
                }
                act.reward = act.reward * decay + reward;
                act.count = act.count * decay + 1.0;
                act.alpha = 1.0 + act.reward;
                act.beta = 1.0 + (act.count - act.reward);
            }
            rewards.add(act.reward);
            counts.add(act.count);
            alphas.add(act.alpha);
            betas.add(act.beta);
            candiList.add(act);
        }
        int numMachines = candiList.size();
        ActivityInfo result = (ActivityInfo)candiList.get(ActivitySelector.selectMachine(alphas, betas, numMachines));
        mMap.clear();
        return result;
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    static class MatchInfo {
        double score;
        ActivityInfo act;

        MatchInfo() {
        }
    }

    static class RankInfo {
        long id;
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double rrpm;
        double rexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double RT_REWARD_WEIGHT = 0.0;
        static double NEW_PERCENT = 0.5;
        static double MIN_REWARD = 0.01;
        static long MAX_CLICK = 300L;
        static long DISCOUNT = 2L;
        static double DECAY = 0.999;

        Constant() {
        }
    }
}

