/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.activityselect;

import cn.com.duiba.nezha.compute.common.model.activityselect.ActivityInfo;
import cn.com.duiba.nezha.compute.common.model.activityselect.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitySelector {
    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int)(c1.score - c2.score);
        }
    };

    public static List<ActivityInfo> match(List<ActivityInfo> activityInfos, int topn) {
        ArrayList<ActivityInfo> result = new ArrayList<ActivityInfo>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        for (ActivityInfo activity : activityInfos) {
            if (activity.hisRequest.globalVal < 100.0) {
                if (activityInfos.size() > 100 && Math.random() < 0.01) {
                    result.add(activity);
                    continue;
                }
                result.add(activity);
                continue;
            }
            double slotRpmLeft = activity.hisSend.slotVal != Double.NaN ? ActivitySelector.wilsonRoofLeft(activity.hisSend.slotVal / 5.0, activity.hisRequest.slotVal) : 0.0;
            double globalRpmLeft = activity.hisSend.globalVal != Double.NaN ? ActivitySelector.wilsonRoofLeft(activity.hisSend.globalVal / 5.0, activity.hisRequest.globalVal) : 0.0;
            double appRpmLeft = activity.hisSend.appVal != Double.NaN ? ActivitySelector.wilsonRoofLeft(activity.hisSend.appVal / 5.0, activity.hisRequest.appVal) : 0.0;
            double coef = 0.0;
            double rpm = 0.0;
            double confidence = Math.min(activity.hisSend.appVal / 1000.0, 1.0);
            coef = confidence * 0.7 * Math.ceil(Math.max(slotRpmLeft, appRpmLeft)) + (1.0 - confidence) * 0.3 * Math.ceil(globalRpmLeft);
            rpm = coef / (confidence * 0.7 * Math.max(slotRpmLeft, appRpmLeft) + (1.0 - confidence) * 0.3 * globalRpmLeft);
            MatchInfo info = new MatchInfo();
            info.act = activity;
            info.score = rpm;
            candis.add(info);
            candis.add(info);
        }
        for (int i = 0; i < topn && i < candis.size(); ++i) {
            result.add(((MatchInfo)candis.poll()).act);
        }
        return result;
    }

    public static ActivityInfo select(List<ActivityInfo> activityInfos) {
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        double decay = Constant.DECAY;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = 0.1;
        double maxH = 0.1;
        double maxA = 0.1;
        activityInfos = ActivitySelector.match(activityInfos, 100);
        for (ActivityInfo act : activityInfos) {
            double hrpm;
            double arpm;
            double grpm;
            double request = 0.0;
            double send = 0.0;
            request = act.request.globalVal - act.lastRequest.globalVal;
            send = act.send.globalVal - act.lastSend.globalVal;
            act.hisSend.globalVal = act.hisSend.globalVal > 10000.0 ? act.hisSend.globalVal / (double)Constant.DISCOUNT : act.hisSend.globalVal + send;
            act.hisRequest.globalVal = act.hisSend.globalVal > 10000.0 ? act.hisRequest.globalVal / (double)Constant.DISCOUNT : act.hisRequest.globalVal + request;
            RankInfo info = mMap.containsKey(act.activityId) ? (RankInfo)mMap.get(act.activityId) : new RankInfo();
            info.grpm = grpm = act.hisSend.globalVal / act.hisRequest.globalVal;
            info.gexp = act.hisRequest.globalVal;
            maxG = Math.max(grpm, maxG);
            request = act.request.appVal - act.lastRequest.appVal;
            send = act.send.appVal - act.lastSend.appVal;
            act.hisSend.appVal = act.hisSend.appVal > 10000.0 ? act.hisSend.appVal / (double)Constant.DISCOUNT : act.hisSend.appVal + send;
            act.hisRequest.appVal = act.hisSend.appVal > 10000.0 ? act.hisRequest.appVal / (double)Constant.DISCOUNT : act.hisRequest.appVal + request;
            info.arpm = arpm = act.hisSend.appVal / act.hisRequest.appVal;
            info.aexp = act.hisRequest.appVal;
            mMap.put(act.activityId, info);
            if (info.hexp > 50.0) {
                maxA = Math.max(arpm, maxA);
            }
            request = act.request.slotVal - act.lastRequest.slotVal;
            send = act.send.slotVal - act.lastSend.slotVal;
            act.hisSend.slotVal = act.hisSend.slotVal > 10000.0 ? act.hisSend.slotVal / (double)Constant.DISCOUNT : act.hisSend.slotVal + send;
            act.hisRequest.slotVal = act.hisSend.slotVal > 10000.0 ? act.hisRequest.slotVal / (double)Constant.DISCOUNT : act.hisRequest.slotVal + request;
            info.hrpm = hrpm = act.hisSend.slotVal / act.hisRequest.slotVal;
            info.hexp = act.hisRequest.slotVal;
            mMap.put(act.activityId, info);
            if (!(info.hexp > 50.0)) continue;
            maxH = Math.max(hrpm, maxH);
        }
        ArrayList<ActivityInfo> candiList = new ArrayList<ActivityInfo>();
        for (ActivityInfo act : activityInfos) {
            if (act.request.globalVal > 0.0) {
                double reward = Constant.MIN_REWARD;
                double confidence = act.hisSend.slotVal > 1000.0 ? 1.0 : act.hisSend.slotVal / 1000.0;
                reward = (1.0 - confidence) * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).grpm, maxG, 1.0) + confidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).hrpm, maxH, 1.0);
                reward = Math.max(reward, Constant.MIN_REWARD);
                if (act.count < 20.0) {
                    act.count = 20.0;
                    act.reward = Math.min(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).grpm * act.count / maxG, act.count);
                }
                act.reward = act.reward * decay + reward;
                act.count = act.count * decay + 1.0;
                act.alpha = 1.0 + act.reward;
                act.beta = 1.0 + (act.count - act.reward);
            }
            rewards.add(act.reward);
            counts.add(act.count);
            alphas.add(act.alpha);
            betas.add(act.beta);
            candiList.add(act);
        }
        int numMachines = candiList.size();
        ActivityInfo result = (ActivityInfo)candiList.get(ActivitySelector.selectMachine(alphas, betas, numMachines));
        result.lastRequest = result.request;
        result.lastSend = result.send;
        result.lastClick = result.click;
        if (System.currentTimeMillis() - result.updateTime > 60000L && result.request.globalVal - result.lastRequest.globalVal > 100.0) {
            result.isUpdate = true;
        }
        mMap.clear();
        return result;
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    static class MatchInfo {
        double score;
        ActivityInfo act;

        MatchInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2L;
        static double DECAY = 0.999;

        Constant() {
        }
    }
}

