/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.activityselect;

import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonPair;

public class WilsonInterval {
    public static WilsonPair wilsonCalc(long numerator, long denominator) {
        if (denominator == 0L) {
            return new WilsonPair(0.0, 0.0);
        }
        double z = 1.6;
        double phat = (double)numerator / (double)denominator;
        double denorm = 1.0 + z * z / (double)denominator;
        double enum1 = phat + z * z / (double)(2L * denominator);
        double enum2 = z * Math.sqrt(phat * (1.0 - phat) / (double)denominator + z * z / (double)(4L * denominator * denominator));
        return new WilsonPair((enum1 - enum2) / denorm, (enum1 + enum2) / denorm);
    }

    public static WilsonPair wilsonCalc97(long numerator, long denominator) {
        if (denominator == 0L) {
            return new WilsonPair(0.0, 0.0);
        }
        double z = 2.2;
        double phat = (double)numerator / (double)denominator;
        double denorm = 1.0 + z * z / (double)denominator;
        double enum1 = phat + z * z / (double)(2L * denominator);
        double enum2 = z * Math.sqrt(phat * (1.0 - phat) / (double)denominator + z * z / (double)(4L * denominator * denominator));
        return new WilsonPair((enum1 - enum2) / denorm, (enum1 + enum2) / denorm);
    }

    public static void main(String[] args) {
        System.out.println(WilsonInterval.wilsonCalc((long)10L, (long)100L).lowerBound);
        System.out.println(WilsonInterval.wilsonCalc((long)20L, (long)200L).lowerBound);
        System.out.println(WilsonInterval.wilsonCalc((long)40L, (long)200L).lowerBound);
        System.out.println(WilsonInterval.wilsonCalc((long)100L, (long)1000L).lowerBound);
    }
}

