package cn.com.duiba.nezha.compute.common.model.pacing;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Created by jiali on 2017/8/31.
 */
public class Pacing {

    private static final Logger logger = LoggerFactory.getLogger(Pacing.class);

    public class StatInfo
    {
        Double app1h;
        Double app1d;
        Double app7d;
        Double g1h;
        Double g1d;
        Double g7d;

        public void setApp1d(Double app1d) {
            this.app1d = app1d;
        }

        public void setApp1h(Double app1h) {
            this.app1h = app1h;
        }

        public void setApp7d(Double app7d) {
            this.app7d = app7d;
        }

        public void setG1d(Double g1d) {
            this.g1d = g1d;
        }

        public void setG1h(Double g1h) {
            this.g1h = g1h;
        }

        public void setG7d(Double g7d) {
            this.g7d = g7d;
        }

        public Double getApp1d() {
            return app1d;
        }

        public Double getApp1h() {
            return app1h;
        }

        public Double getApp7d() {
            return app7d;
        }

        public Double getG1d() {
            return g1d;
        }

        public Double getG1h() {
            return g1h;
        }

        public Double getG7d() {
            return g7d;
        }
    }
    public class CvrInfo
    {
        Double cvr; //融合值
        StatInfo cvrInfo;

        public void setCvr(Double cvr) {
            this.cvr = cvr;
        }

        public void setCvrInfo(StatInfo cvrInfo) {
            this.cvrInfo = cvrInfo;
        }

        public Double getCvr() {
            return cvr;
        }

        public StatInfo getCvrInfo() {
            return cvrInfo;
        }
    }

    public class CtrInfo
    {
        Double ctr; //融合值
        StatInfo ctrInfo;

        public void setCtr(Double ctr) {
            this.ctr = ctr;
        }

        public void setCtrInfo(StatInfo ctrInfo) {
            this.ctrInfo = ctrInfo;
        }

        public Double getCtr() {
            return ctr;
        }

        public StatInfo getCtrInfo() {
            return ctrInfo;
        }
    }

    public class TimeInfo
    {
        List<Double> hourCtr;
        List<Double> hourCvr;
        List<Double> hourClk;
        List<Double> hourExp;
        List<Double> hourFee;
        List<Double> hourBudgetFee;
        List<Double> hourBudgetExp;
        Double packageBudget;

        public void setHourBudgetExp(List<Double> hourBudgetExp) {
            this.hourBudgetExp = hourBudgetExp;
        }

        public void setHourBudgetFee(List<Double> hourBudgetFee) {
            this.hourBudgetFee = hourBudgetFee;
        }

        public void setHourExp(List<Double> hourExp) {
            this.hourExp = hourExp;
        }

        public void setPackageBudget(Double packageBudget) {
            this.packageBudget = packageBudget;
        }

        public void setHourClk(List<Double> hourClk) {
            this.hourClk = hourClk;
        }

        public void setHourCtr(List<Double> hourCtr) {
            this.hourCtr = hourCtr;
        }

        public void setHourCvr(List<Double> hourCvr) {
            this.hourCvr = hourCvr;
        }

        public Double getPackageBudget() {
            return packageBudget;
        }

        public List<Double> getHourBudgetExp() {
            return hourBudgetExp;
        }

        public List<Double> getHourBudgetFee() {
            return hourBudgetFee;
        }

        public List<Double> getHourExp() {
            return hourExp;
        }

        public List<Double> getHourClk() {
            return hourClk;
        }

        public List<Double> getHourCtr() {
            return hourCtr;
        }

        public List<Double> getHourCvr() {
            return hourCvr;
        }

        public void setHourFee(List<Double> hourFee) {
            this.hourFee = hourFee;
        }

        public List<Double> getHourFee() {
            return hourFee;
        }
    }

    public boolean check()
    {
        return true;
    }

    public boolean pacing(Long advertId, Integer  type, Long fee, Double factor,
                          CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo)
    {
        boolean isGiveUp = false;
        if(type == 2)
        {
            Double  competence = competence(cvrInfo,ctrInfo,clkInfo,timeInfo);
            Double priceScore = priceScore(type, fee, factor, clkInfo,timeInfo);
            Double prob = competence * priceScore;
            double risk = risk(cvrInfo,ctrInfo,clkInfo,timeInfo);
            boolean isRisk = Math.random() < risk ? true : false;

            if(!isRisk)
            {
                isGiveUp = Math.random() > competence ? true : false;
            }
            if(!isGiveUp)
            {
                isGiveUp = Math.random() > priceScore ? true : false;
            }

            if(Math.random()<0.001 && isGiveUp)
            {
                logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", advertId, isGiveUp,competence,priceScore,risk);
            }
            else if(Math.random()<0.0001 && !isGiveUp)
            {
                logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", advertId, isGiveUp,competence,priceScore,risk);
            }
        }

        return isGiveUp;
    }

    public double wilsonRoofLeft(Double ratio, Double num)
    {
        if(ratio == null || num == null)
            return 0;
        long fenzi = (long) (ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio)
    {
        if(ratio == null || num == null)
            return 0;
        if(ratio == 0)
        {
            ratio = 0.00000001;
        }
        long fenmu = (long) (num/ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu)
    {
        if(fenzi == null || fenmu == null)
            return 0;
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi.longValue(), fenmu.longValue());
        return pair.lowerBound;
    }

    public double competence(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo)
    {
        double app7dCvr = wilsonRoofLeft(cvrInfo.cvrInfo.app7d,clkInfo.app7d);
        double app1dCvr = wilsonRoofLeft(cvrInfo.cvrInfo.app1d,clkInfo.app1d);
        double app1hCvr = wilsonRoofLeft(cvrInfo.cvrInfo.app1h,clkInfo.app1h);
        double global7dCvr = wilsonRoofLeft(cvrInfo.cvrInfo.g7d,clkInfo.g7d);
        double global1dCvr = wilsonRoofLeft(cvrInfo.cvrInfo.g1d,clkInfo.g1d);
        double global1hCvr = wilsonRoofLeft(cvrInfo.cvrInfo.g1h,clkInfo.g1h);
        double cvr = cvrInfo.cvr;
        double coefApp = 0.7 * Math.ceil(app7dCvr) + 0.21 * Math.ceil(app1dCvr) + 0.09 * Math.ceil(app1hCvr);
        double coefGlobal = 0.7 * Math.ceil(global7dCvr) + 0.21 * Math.ceil(global1dCvr) + 0.09 * Math.ceil(global1hCvr);
        double competenceApp =  coefApp > 0 ? coefApp * cvr / (0.7 * app7dCvr + 0.21 * app1dCvr + 0.09 * app1hCvr) : 1;
        double competenceGlobal = coefGlobal > 0 ? coefGlobal * cvr / (0.7 * global7dCvr + 0.21 * global1dCvr + 0.09 * global1hCvr) : 1;

        //System.out.println(competenceGlobal+"\t"+cvrInfo.cvrInfo.app1h+"\t"+app1hCvr);
        if((competenceGlobal < 0.3) || (competenceApp < 0.7 && competenceGlobal < 0.5))
        {
            return competenceGlobal;
        }

        return 1;
    }

    public double risk(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo)
    {
        double risk = 0;
        double arpuRisk;
        double costRisk;
        double app7dCtr = wilsonRoofRight(clkInfo.app7d,ctrInfo.ctrInfo.app7d);
        double app1dCtr = wilsonRoofRight(clkInfo.app1d,ctrInfo.ctrInfo.app1d);
        double app1hCtr = wilsonRoofRight(clkInfo.app1h,ctrInfo.ctrInfo.app1h);
        double global7dCtr = wilsonRoofRight(clkInfo.g7d,ctrInfo.ctrInfo.g7d);
        double global1dCtr = wilsonRoofRight(clkInfo.g1d,ctrInfo.ctrInfo.g1d);
        double global1hCtr = wilsonRoofRight(clkInfo.g1h,ctrInfo.ctrInfo.g1h);
        double ctr = ctrInfo.ctr;
        double coefApp = 0.7 * app7dCtr > 0 ? 1 : 0 + 0.21 * app1dCtr > 0 ? 1 : 0 + 0.09 * app1hCtr > 0 ? 1 : 0;
        double coefGlobal = 0.7 * global7dCtr > 0 ? 1 : 0 + 0.21 * global1dCtr > 0 ? 1 : 0 + 0.09 * global1hCtr > 0 ? 1 : 0;
        double competenceApp =  coefApp * ctr / (0.7 * app7dCtr + 0.21 * app1dCtr + 0.09 * app1hCtr);
        double competenceGlobal = coefGlobal * ctr / (0.7 * global7dCtr + 0.21 * global1dCtr + 0.09 * global1hCtr);
        if(competenceGlobal > 1)
        {
            risk = 1;
        }

        double budget = timeInfo.packageBudget;
        if(budget <= 0)
        {
            risk = 1;
        }

        return risk;
    }

    public double priceScore(int type , Long fee, Double factor, StatInfo clkInfo, TimeInfo timeInfo)
    {
        double confidence = 0;

        double fee1d = 0, clk1d = 0;
        for(double fee1h : timeInfo.hourFee)
        {
            if(fee1h != -1) fee1d += fee1h;
        }
        for(double clk1h : timeInfo.hourClk)
        {
            if(clk1d != -1) clk1d += clk1h;
        }
        double cpc = clk1d > 0 ? fee1d / clk1d : 50;

        if(cpc >= 20) {
            double feeOri = factor != 0 ? fee / factor : fee;
            if(fee <= 10)
            {
                return 0.1 * fee / 10;
            }
            else if((fee > 10 && fee<=15) && feeOri < 20)
            {
                return 0.5;
            }
        }

        return 1;
    }
}
