/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.stat;

import cn.com.duiba.nezha.compute.stat.dto.StatDto;
import cn.com.duiba.nezha.compute.stat.utils.AssertUtil;
import cn.com.duiba.nezha.compute.stat.utils.MathUtil;
import cn.com.duiba.nezha.compute.stat.utils.MergerUtil;
import java.util.Map;

public class StatMerger {
    public static StatDto dimsMerge(StatDto appDto, StatDto activityDto, StatDto slotDto, StatDto globalDto) throws Exception {
        StatDto ret = null;
        if (globalDto != null && globalDto.getLaunchCnt() > 50L) {
            ret = globalDto;
        }
        if (activityDto != null && activityDto.getLaunchCnt() > 50L) {
            ret = activityDto;
        }
        if (appDto != null && appDto.getLaunchCnt() > 50L) {
            ret = appDto;
        }
        if (slotDto != null && slotDto.getLaunchCnt() > 50L) {
            ret = slotDto;
        }
        return ret;
    }

    public static StatDto dimMerge(StatDto dimDto, StatDto globalDto) throws Exception {
        StatDto ret = null;
        if (globalDto != null && globalDto.getLaunchCnt() > 50L) {
            ret = globalDto;
        }
        if (dimDto != null && dimDto.getLaunchCnt() > 20L) {
            ret = dimDto;
        }
        return ret;
    }

    public static StatDto intervalMerge(Map<Long, StatDto> statDtoHourMap, Map<Long, StatDto> statDtoDayMap) throws Exception {
        StatDto ret = null;
        if (AssertUtil.isAllEmpty(statDtoHourMap, statDtoDayMap)) {
            return ret;
        }
        ret = new StatDto();
        StatDto hourMergeDto = StatMerger.intervalMerge(statDtoHourMap, 2, 1L);
        StatDto dayMergeDto = StatMerger.intervalMerge(statDtoDayMap, 3, 2L);
        long hourLaunchCnt = 0L;
        long hourChargeCnt = 0L;
        long hourActClickCnt = 0L;
        long hourActExpCnt = 0L;
        long dayLaunchCnt = 0L;
        long dayChargeCnt = 0L;
        long dayActClickCnt = 0L;
        long dayActExpCnt = 0L;
        if (hourMergeDto != null) {
            hourLaunchCnt = MathUtil.tolong(hourMergeDto.getLaunchCnt());
            hourChargeCnt = MathUtil.tolong(hourMergeDto.getChargeCnt());
            hourActClickCnt = MathUtil.tolong(hourMergeDto.getActClickCnt());
            hourActExpCnt = MathUtil.tolong(hourMergeDto.getActExpCnt());
        }
        if (dayMergeDto != null) {
            dayLaunchCnt = MathUtil.tolong(dayMergeDto.getLaunchCnt());
            dayChargeCnt = MathUtil.tolong(dayMergeDto.getChargeCnt());
            dayActClickCnt = MathUtil.tolong(dayMergeDto.getActClickCnt());
            dayActExpCnt = MathUtil.tolong(dayMergeDto.getActExpCnt());
        }
        double historyCtr = MergerUtil.getCtrWithBias(dayChargeCnt, dayLaunchCnt, 200L, (Double)0.3, 100L, 5);
        double historyCvr = MergerUtil.getCtrWithBias(dayActClickCnt, dayChargeCnt, 200L, (Double)0.05, 100L, 5);
        double mergeCtr = MergerUtil.getCtrWithBias(hourChargeCnt, hourLaunchCnt, 200L, (Double)historyCtr, 200L, 5);
        double mergeCvr = MergerUtil.getCtrWithBias(hourActClickCnt, hourChargeCnt, 200L, (Double)historyCvr, 200L, 5);
        ret.setLaunchCnt(hourLaunchCnt);
        ret.setChargeCnt(hourChargeCnt);
        ret.setActClickCnt(hourActClickCnt);
        ret.setActExpCnt(hourActExpCnt);
        ret.setMergeCtr(mergeCtr);
        ret.setMergeCvr(mergeCvr);
        return ret;
    }

    private static StatDto intervalMerge(Map<Long, StatDto> statDtoMap, int upLimit, Long type) throws Exception {
        StatDto ret = null;
        if (AssertUtil.isEmpty(statDtoMap) || type == null) {
            return ret;
        }
        ret = new StatDto();
        Long weightCnt = 0L;
        Long launchCnt = 0L;
        Long chargeCnt = 0L;
        Long actClickCnt = 0L;
        Long actExpCnt = 0L;
        int i = 0;
        for (Map.Entry<Long, StatDto> entry : statDtoMap.entrySet()) {
            Long index = entry.getKey();
            Long weight = StatMerger.mergeWeight(index, type, upLimit);
            StatDto dto = entry.getValue();
            if (weight == null || !((double)weight.longValue() > 0.0) || dto == null) continue;
            weightCnt = weightCnt + weight;
            launchCnt = MathUtil.add(MathUtil.dot(dto.getLaunchCnt(), weight), launchCnt);
            chargeCnt = MathUtil.add(MathUtil.dot(dto.getChargeCnt(), weight), chargeCnt);
            actClickCnt = MathUtil.add(MathUtil.dot(dto.getActClickCnt(), weight), actClickCnt);
            actExpCnt = MathUtil.add(MathUtil.dot(dto.getActExpCnt(), weight), actExpCnt);
            ++i;
        }
        ret.setLaunchCnt(MathUtil.division(launchCnt, (Long)(weightCnt / (long)i)));
        ret.setChargeCnt(MathUtil.division(chargeCnt, (Long)(weightCnt / (long)i)));
        ret.setActExpCnt(MathUtil.division(actExpCnt, (Long)(weightCnt / (long)i)));
        ret.setActClickCnt(MathUtil.division(actClickCnt, (Long)(weightCnt / (long)i)));
        return ret;
    }

    public static Long mergeWeight(Long lastNum, Long type, long upLimit) {
        Long ret = null;
        if (lastNum > upLimit) {
            return ret;
        }
        if (type.equals(1L)) {
            ret = MergerUtil.hourMergeWeight(lastNum);
        }
        if (type.equals(2L)) {
            ret = MergerUtil.dayMergeWeight(lastNum);
        }
        return ret;
    }
}

