package feedback;

import shapeless.ops.nat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlotFeedBack {
    public static Map<String,String> slotFeedBack(List<SlotFeedBackInfo> infoList) {

        Map<String,String> blackMap=new HashMap<String, String>();

        for (int i = 0; i < infoList.size(); i++) {
            //System.out.println(infoList.get(i));
            SlotFeedBackInfo SlotFeedBackInfo = infoList.get(i);
            String slotId = SlotFeedBackInfo.slotId;
            String advertId = SlotFeedBackInfo.advertId;
            String orientationId = SlotFeedBackInfo.orientationId;
            String type = SlotFeedBackInfo.type; ;            //type=hour:表示小时数据， day ：表示1天粒度的指标数据
            Integer chargeType=SlotFeedBackInfo.chargeType;
            Long cost = SlotFeedBackInfo.cost;              //托管配置消耗
            Long convert = SlotFeedBackInfo.convert;           //托管配置转化量
            Long targetCostConvert = SlotFeedBackInfo.targetCostConvert;  //目标成本

            Float CostConvert = (float) cost / convert; //实时成本
            String blackKey = "NZ_K77_" + SlotFeedBackInfo.slotId + "_" + SlotFeedBackInfo.advertId + "_" + SlotFeedBackInfo.orientationId + "_" + SlotFeedBackInfo.targetCostConvert;
            String value = "True";
            //NZ_K77_slotId_advertId_orientationId_targetCostConvert

            //cpc
            if (chargeType==1){
                double chargetypeRatio = 0.8;
                if (type.equals("day") && convert > 5 && CostConvert > chargetypeRatio * 4 * targetCostConvert) {
                    blackMap.put(blackKey, value);
                } else if (type.equals("day") && convert == 0 && cost > Math.min(10000L,6*targetCostConvert)) {
                    blackMap.put(blackKey, value);
                } else if (type.equals("hour") && convert>2 && CostConvert > 4 * targetCostConvert) {
                    blackMap.put(blackKey, value);
                } else if (type.equals("hour") && convert == 0 && cost > Math.min(10000L,6*targetCostConvert)) {
                    blackMap.put(blackKey, value);
                }
            }else {
                double chargetypeRatio = 1;
                if (type.equals("day") && convert > 5 && CostConvert > chargetypeRatio * 4 * targetCostConvert) {
                    blackMap.put(blackKey, value);
                } else if (type.equals("day") && convert == 0 && cost > Math.min(10000L,6*targetCostConvert)) {
                    blackMap.put(blackKey, value);
                } else if (type.equals("hour") && convert>2 && CostConvert > 4 * targetCostConvert) {
                    blackMap.put(blackKey, value);
                } else if (type.equals("hour") && convert == 0 && cost > Math.min(10000L,6*targetCostConvert)) {
                    blackMap.put(blackKey, value);
                }
            }



        }
        return blackMap;
    }
}
