package cn.com.duiba.nezha.engine.biz.domain;

import cn.com.duiba.nezha.engine.common.utils.HBaseField;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.util.Optional;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ConsumerFeatureDO.java , v 0.1 2017/10/30 上午11:33 ZhouFeng Exp $
 */
public class ConsumerFeatureDO {

    /**
     * 订单总数 等于 当天+昨日 +前日 在get方法中
     */
    private Long orderCount;

    /**
     * 当天订单数
     */
    private Long currentDayOrderCount;
    /**
     * 昨日订单数
     */
    private Long yesterDayOrderCount;

    /**
     * 前日订单数
     */
    private Long beforeYesterDayOrderCount;


    /**
     * 最新订单时间
     */
    private String lastOrderTime;

    /**
     * 最新订单ID
     */
    private String lastOrderId;

    /**
     * 计费订单ID
     */
    private String billingOrderId;

    /**
     * 最新活动ID
     */
    private String lastActivityId;

    /**
     * 是否有计费订单 0：没有 1：有  通过比较 billingOrderId与lastOrderId 是否相同 在get方法中
     */
    private String isBilling;

    public Long getOrderCount() {
        return BigDecimal.valueOf(getCurrentDayOrderCount()).add(BigDecimal.valueOf(getYesterDayOrderCount())).add(BigDecimal.valueOf(getBeforeYesterDayOrderCount())).longValue();
    }

    public void setOrderCount(Long orderCount) {
        this.orderCount = orderCount;
    }

    public Long getCurrentDayOrderCount() {
        return Optional.ofNullable(currentDayOrderCount).orElse(0L);
    }

    public void setCurrentDayOrderCount(Long currentDayOrderCount) {
        this.currentDayOrderCount = currentDayOrderCount;
    }


    public String getLastOrderTime() {
        return lastOrderTime;
    }

    public void setLastOrderTime(String lastOrderTime) {
        this.lastOrderTime = lastOrderTime;
    }

    public String getLastOrderId() {
        return lastOrderId;
    }

    public void setLastOrderId(String lastOrderId) {
        this.lastOrderId = lastOrderId;
    }

    public String getLastActivityId() {
        return lastActivityId;
    }

    public void setLastActivityId(String lastActivityId) {
        this.lastActivityId = lastActivityId;
    }

    public String getIsBilling() {
        return StringUtils.equals(billingOrderId, lastOrderId) ? "1" : "0";
    }

    public void setIsBilling(String isBilling) {
        this.isBilling = isBilling;
    }

    public Long getYesterDayOrderCount() {
        return Optional.ofNullable(yesterDayOrderCount).orElse(0L);
    }

    public void setYesterDayOrderCount(Long yesterDayOrderCount) {
        this.yesterDayOrderCount = yesterDayOrderCount;
    }

    public Long getBeforeYesterDayOrderCount() {
        return Optional.ofNullable(beforeYesterDayOrderCount).orElse(0L);
    }

    public void setBeforeYesterDayOrderCount(Long beforeYesterDayOrderCount) {
        this.beforeYesterDayOrderCount = beforeYesterDayOrderCount;
    }

    public String getBillingOrderId() {
        return billingOrderId;
    }

    public void setBillingOrderId(String billingOrderId) {
        this.billingOrderId = billingOrderId;
    }
}


