package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.engine.api.enums.EncourageAdvertAlgEnum;
import cn.com.duiba.nezha.engine.api.enums.ModelKeyEnum;
import cn.com.duiba.nezha.engine.api.enums.PredictCorrectType;
import cn.com.duiba.nezha.engine.biz.enums.RecommendMaterialType;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import org.springframework.stereotype.Service;

import static cn.com.duiba.nezha.engine.biz.vo.advert.AdvertStatDimWeightVo.advertStatDimWeightVoA;
import static cn.com.duiba.nezha.engine.biz.vo.advert.AdvertStatDimWeightVo.advertStatDimWeightVoB;

@Service
public class EncourageAdvertRecommendService extends AbstractAdvertRecommendService {
    @Override
    public void prepareStrategyParameter(AdvertRecommendRequestVo advertRecommendRequestVo) {
        EncourageAdvertAlgEnum encourageAdvertAlgEnum = (EncourageAdvertAlgEnum) advertRecommendRequestVo.getAdvertAlgEnum();
        //CTR预估模型Key
        ModelKeyEnum ctrModelKey;

        //CVR预估模型Key
        ModelKeyEnum cvrModelKey;

        PredictCorrectType predictCorrectType = PredictCorrectType.NONE;

        RecommendMaterialType recommendMaterialType = RecommendMaterialType.NONE;

        MutModelType mutModelType = MutModelType.NORMAL;


        switch (encourageAdvertAlgEnum) {
            case ENCOURAGE_AND_PC_1:
                ctrModelKey = ModelKeyEnum.ZZ_FTRL_FM_CTR_MODEL_v001;
                cvrModelKey = ModelKeyEnum.ZZ_MID_FTRL_FM_BCVR_V001;
                break;
            default:
                throw new RuntimeException("策略不存在");
        }
        advertRecommendRequestVo.setAdvertStatDimWeightVo(advertStatDimWeightVoB);
        advertRecommendRequestVo.setCtrModelKey(ctrModelKey);
        advertRecommendRequestVo.setCvrModelKey(cvrModelKey);
        advertRecommendRequestVo.setRecommendMaterialType(recommendMaterialType);
        advertRecommendRequestVo.setPredictCorrectType(predictCorrectType);
        advertRecommendRequestVo.setAdvertMultiDimScoreEffective(false);
        advertRecommendRequestVo.setInvokeWeakFilter(false);
        advertRecommendRequestVo.setNeedPredict(true);
        advertRecommendRequestVo.setMutModelType(mutModelType);
    }
}
