package cn.com.duiba.nezha.engine.biz.service.advert.ctr;

import cn.com.duiba.nezha.alg.alg.vo.BiddingRateDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public interface NewAdvertSupportService {

    void incrBidingCount(BiddingKey advertKey, long size);

    BiddingRateDo getBiddingRate(BiddingKey advertKey);

    void insertOutGoing(OrientationPackage orientationPackage, Long slotId);

    Map<BiddingKey, Stat> getCacheInfo();

    public static class BiddingKey {

        //广告id
        private Long advertId;
        //配置id
        private Long orientationId;
        //广告位id
        private Long slotId;
        //行业id
        private String newTradeTagNum;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BiddingKey)) {
                return false;
            }
            BiddingKey that = (BiddingKey) o;
            return Objects.equals(advertId, that.advertId) &&
                    Objects.equals(orientationId, that.orientationId) &&
                    Objects.equals(slotId, that.slotId) &&
                    Objects.equals(newTradeTagNum, that.newTradeTagNum);
        }

        @Override
        public int hashCode() {
            return Objects.hash(advertId, orientationId, slotId, newTradeTagNum);
        }

        public Long getAdvertId() {
            return advertId;
        }

        public void setAdvertId(Long advertId) {
            this.advertId = advertId;
        }

        public Long getOrientationId() {
            return orientationId;
        }

        public void setOrientationId(Long orientationId) {
            this.orientationId = orientationId;
        }

        public Long getSlotId() {
            return slotId;
        }

        public void setSlotId(Long slotId) {
            this.slotId = slotId;
        }

        public String getNewTradeTagNum() { return newTradeTagNum; }

        public void setNewTradeTagNum(String newTradeTagNum) { this.newTradeTagNum = newTradeTagNum; }

        public static BiddingKey getAdvertKey(Long advertId, Long slotId) {
            BiddingKey advertKey = new BiddingKey();
            advertKey.setAdvertId(advertId);
            advertKey.setSlotId(slotId);
            return advertKey;
        }

        public static BiddingKey getAdvertAndOrientationKey(Long advertId, Long packageId, Long slotId) {
            BiddingKey advertAndOrientationKey = new BiddingKey();
            advertAndOrientationKey.setAdvertId(advertId);
            advertAndOrientationKey.setSlotId(slotId);
            advertAndOrientationKey.setOrientationId(packageId);
            return advertAndOrientationKey;
        }

        public static BiddingKey getSlotKey(Long slotId) {
            BiddingKey slotKey = new BiddingKey();
            slotKey.setSlotId(slotId);
            return slotKey;
        }

        public static BiddingKey getTradeAndSlotKey(Long slotId, String newTradeTagNum) {
            BiddingKey tradeAndSlotKey = new BiddingKey();
            tradeAndSlotKey.setNewTradeTagNum(newTradeTagNum);
            tradeAndSlotKey.setSlotId(slotId);
            return tradeAndSlotKey;
        }
    }

    class Stat {

        //传入总计
        private AtomicLong inComing;
        //传出总计
        private AtomicLong outGoing;

        public AtomicLong getInComing() { return inComing; }

        public void setInComing(AtomicLong inComing) { this.inComing = inComing; }

        public AtomicLong getOutGoing() { return outGoing; }

        public void setOutGoing(AtomicLong outGoing) { this.outGoing = outGoing; }
    }

}
