package cn.com.duiba.nezha.engine.biz.service.advert.engine.impl;

import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.engine.EncourageArpuOneService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Service
public class EncourageArpuOneServiceImpl extends CacheService implements EncourageArpuOneService {

    private static final Double DEFAULT_ARUP = -1D;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    private LoadingCache<String, Double> encourageCache = CacheBuilder.newBuilder()
            .expireAfterAccess(1, TimeUnit.MINUTES).build(new CacheLoader<String, Double>() {
                @Override
                public Double load(String key) throws Exception {
                    String arup = stringRedisTemplate.opsForValue().get(key);

                    if(StringUtils.isEmpty(arup)){
                        return DEFAULT_ARUP;
                    }
                    return Double.valueOf(arup);
                }
            });


    @Override
    public void insertArpu(String orderId, Double arpu) {
        if (arpu == null) {
            arpu = DEFAULT_ARUP;
        }
        // 从redis, put进去.
        stringRedisTemplate.opsForValue().set(orderId, String.valueOf(arpu), 3, TimeUnit.MINUTES);
    }

    @Override
    public Double getArpuByOrderId(String orderId) {
        try{

            if(StringUtils.isEmpty(orderId)){
                return null;
            }
            return encourageCache.get(orderId);
        }catch (Exception e){
            logger.error("EncourageArpuOneServiceImpl.getArpuByOrderId error :{}", e);
            throw new RecommendEngineException("get getArpuByOrderId error", e);
        }

    }
}
