package cn.com.duiba.nezha.engine.common.utils;

import org.apache.commons.collections.CollectionUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ListToMapTools {
    private ListToMapTools(){}
    /**
     * 将集合转换成map,忽略null对象，如果计算出的key相同，则将用新的值覆盖旧的值
     *
     * eg:
     *  List<A> alist = Lists.newArrayList();
*    *  Map<A.key,A.value> resultToMap = toMap(alist, (a) -> a.getKey(), (a) -> a.getValue());
     *
     * @param source
     * @param keyMapper
     * @param valueMapper
     * @param <K>
     * @param <V>
     * @param <S>
     * @return
     */
    public static <K,V,S> Map<K,V> toMap(Collection<S> source,
                                         Function<? super S, ? extends K> keyMapper,
                                         Function<? super S, ? extends V> valueMapper){
        if(CollectionUtils.isNotEmpty(source)){
            Map<K,V> resultMap = new HashMap<>(source.size());
            source.forEach(s ->{
                if(s != null){
                    resultMap.put(keyMapper.apply(s),valueMapper.apply(s));
                }
            });

            return resultMap;
        }

        return Collections.emptyMap();


    }


}