package cn.com.duiba.odps.center.api.remoteservice.genie;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.genie.ChartDataDto;
import cn.com.duiba.odps.center.api.dto.genie.GenieSqlConfigurationDto;
import cn.com.duiba.odps.center.api.param.genie.ChartDataParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.odps.center.api.dto.genie.GenieChartDto;

@AdvancedFeignClient
public interface RemoteGenieChartService {
    Page<GenieChartDto> getChartList(Integer pageNo, Integer pageSize);
    Page<GenieChartDto> getChartListByName(String chartName,Integer pageNo,Integer pageSize);

    void saveChart (GenieChartDto chartInfo, GenieSqlConfigurationDto sqlInfo);

    GenieChartDto getChartById(Long chartId);
    /**
     * 查询图表数据
     * @param chartDataParam
     * @return
     * @throws BizException
     */
    ChartDataDto getChartData(ChartDataParam chartDataParam) throws BizException;

    void deleteChartById(Long id);
}
