package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.MallSkinDataDto;
import cn.com.duiba.odps.center.api.param.MallSkinParam;

import java.util.Date;
import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/4/15 14:52
 * @description:
 */
@AdvancedFeignClient
public interface RemoteMallSkinDataService {

    /**
     * 根据appId和开始日期、结束日期、页面id，分页查询页面明细数据
     */
    Page<MallSkinDataDto> getPage(MallSkinParam mallSkinParam);

    /**
     * 根据appId和开始日期、结束日期、皮肤id，查询每日的总PV和总UV
     */
    List<MallSkinDataDto> getDateData(Long appId, Date startTime, Date endTime, Long skinId);

    /**
     * 根据appId和开始日期、结束日期，查询每个页面在该时间段的的总PV和总UV
     */
    List<MallSkinDataDto> getSkinData(Long appId, Date startTime, Date endTime);
}
