package cn.com.duiba.odps.center.api.remoteservice.genie;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.genie.GeniePageDto;
import cn.com.duiba.odps.center.api.dto.genie.PageAndTabDto;
import cn.com.duiba.odps.center.api.param.genie.Page4CmsQueries;

/**
 * 智能分析系统页面服务
 * Created by sunyan on 2019/8/8.
 */
@AdvancedFeignClient
public interface RemoteGeniePageService {
    /**
     * 根据页面id获取页面列表数据
     */
    GeniePageDto selectById(Long id);
    /**
     * 获取页面列表数据
     */
    Page<GeniePageDto> getPageList(Integer pageNo,Integer pageSize);
    /**
     * 名称查询获取页面列表数据
     */
    Page<GeniePageDto> getPageListByName(Integer pageNo,Integer pageSize,String pageName);
    /**
     * 用户自定义ID获取页面列表数据
     */
    Page<GeniePageDto> getPageListByCustomizeId(Integer pageNo,Integer pageSize,String pageCustomizeId);
    /**
     * 获取cms端页面列表分页数据
     */
    Page<GeniePageDto> selectPage4Cms(Page4CmsQueries page4CmsQueries);
    /**
     * 更改页面投放状态
     */
    Integer updateDeliveryStateById(Long pageId, Boolean deliveryState);
    /**
     * 删除页面
     */
    Integer deletePageById(Long pageId);
    /**
     * 获取页面详情
     */
    PageAndTabDto getPageDetails(Long pageId);
    /**
     * 保存页面
     */
    Integer savePageDetails(PageAndTabDto pageAndTabDto);
}
