package cn.com.duiba.odps.center.api.param;

import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by HePeng on 2019/05/09 14:27.
 */
public class ActAppDateRangePaginationParam implements Serializable {
    private static final long serialVersionUID = -1862376723815946410L;

    /**
     * 活动id
     * not null
     */
    private Long actId;

    /**
     * 应用id
     * not null
     */
    private Long appId;

    /**
     * 开始日期（包含）
     * not null
     */
    private Date startDateInclusive;

    /**
     * 结束日期（包含）
     * not null
     */
    private Date endDateInclusive;

    /**
     * 每页多少条
     * not null
     */
    private Integer pageSize;

    /**
     * 第几页（从1开始）
     * not null
     */
    private Integer pageNo;

    /**
     * 活动类型
     * can be null
     */
    private ActivityUniformityTypeEnum actTypeEnum;

    /****************** 后续程序计算值 *******************/
    /**
     * 偏移量，不用传，根据pageSize和pageNo计算得出
     */
    private Integer offset;

    /**
     * 活动类型码，不用传，根据活动类型参数得出
     */
    private Integer actType;

    public Long getActId() {
        return actId;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getStartDateInclusive() {
        return startDateInclusive;
    }

    public void setStartDateInclusive(Date startDateInclusive) {
        this.startDateInclusive = startDateInclusive;
    }

    public Date getEndDateInclusive() {
        return endDateInclusive;
    }

    public void setEndDateInclusive(Date endDateInclusive) {
        this.endDateInclusive = endDateInclusive;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public ActivityUniformityTypeEnum getActTypeEnum() {
        return actTypeEnum;
    }

    public void setActTypeEnum(ActivityUniformityTypeEnum actTypeEnum) {
        this.actTypeEnum = actTypeEnum;
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getActType() {
        return actType;
    }

    public void setActType(Integer actType) {
        this.actType = actType;
    }
}
