package cn.com.duiba.odps.center.api.enums.monitor;

import org.apache.commons.lang.StringUtils;

/**
 * 行业销售明细数据表字段
 * Created by sunyan on 2020/2/26.
 */
public enum DataMonitorIndustrySalesDetailEnum {
    APPROVAL_CREATE_TIME("approval_create_time","审批流程创建时间"),
    SALE_NAME("sale_name","销售名称"),
    SALE_TEAM("sale_team","销售所在组"),
    CUSTOM_INDUSTRY("custom_industry","客户行业"),
    CUSTOM_TYPE("custom_type","客户类型"),
    CONTRACT_AMOUNT("contract_amount","合同额"),
    ARRIVAL_AMOUNT("arrival_amount","到账额");

    private String value;

    private String desc;

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
    DataMonitorIndustrySalesDetailEnum(String value,String desc)
    {
        this.value=value;
        this.desc=desc;
    }

    public static DataMonitorIndustrySalesDetailEnum getDataMonitorIndustrySalesDetailEnum(String value) {

        DataMonitorIndustrySalesDetailEnum[] values = DataMonitorIndustrySalesDetailEnum.values();
        for (DataMonitorIndustrySalesDetailEnum format : values) {
            if (StringUtils.equals(format.getValue(),value)) {
                return format;
            }
        }
        return null;
    }
}
