package cn.com.duiba.odps.center.api.remoteservice.zjzy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.zjzy.AreaStatDto;
import cn.com.duiba.odps.center.api.dto.zjzy.OverviewStatDto;
import cn.com.duiba.odps.center.api.dto.zjzy.PrizeStatDto;
import cn.com.duiba.odps.center.api.dto.zjzy.VisitStatDto;

import java.util.Date;
import java.util.List;

/**
 * 浙江中烟-数据实时大屏统计服务类
 * 统计数据查询
 *
 * @author haojiahong
 * @date 2020-08-25
 */
@AdvancedFeignClient
public interface RemoteZjzyQueryStatService {

    /**
     * 大盘实时概况
     *
     * @param statDate 查询数据时间
     * @return 大盘实时概况
     */
    OverviewStatDto getOverviewStat(Date statDate);


    /**
     * 抽奖中奖人数实时统计
     *
     * @param statDate 查询数据时间
     * @return
     */
    List<PrizeStatDto> getPrizeStat(Date statDate);

    /**
     * 用户访问次数分布统计（t+1）
     *
     * @param statDate 查询数据时间
     * @return
     */
    List<VisitStatDto> getVisitStat(Date statDate);

    /**
     * 访问人数地区分布统计（t+1）
     *
     * @param statDate 查询数据时间
     * @param limit    地区排名数量限制
     * @return
     */
    List<AreaStatDto> getAreaStat(Date statDate, Integer limit);


}
