package cn.com.duiba.odps.center.api.enums.monitor;

import org.apache.commons.lang.StringUtils;

/**
 * 爆款玩法明细数据表字端
 * Created by sunyan on 2020/2/26.
 */
public enum DataMonitorHotPlaywayDetailEnum {
    APPROVAL_CREATE_TIME("approval_create_time","审批流程创建时间"),
    ACTIVITY_NAME("activity_name","活动名称"),
    CONTRACT_AMOUNT("contract_amount","合同额"),
    REPLICABLE_PLAY_TYPE("replicable_play_type","可复制玩法类型"),
    ACTUAL_DELIVERY_TIME("actual_delivery_time","实际交付时间"),
    FRONTEND_TOTAL_HOURS("frontend_total_hours","前端总工时"),
    BACKEND_TOTAL_HOURS("backend_total_hours","后端总工时"),
    TEST_TOTAL_HOURS("test_total_hours","测试总工时"),
    TOTAL_HOURS("total_hours","技术总工时");

    private String value;

    private String desc;

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
    DataMonitorHotPlaywayDetailEnum(String value,String desc)
    {
        this.value=value;
        this.desc=desc;
    }

    public static DataMonitorHotPlaywayDetailEnum getDataMonitorHotPlaywayDetailEnum(String value) {

        DataMonitorHotPlaywayDetailEnum[] values = DataMonitorHotPlaywayDetailEnum.values();
        for (DataMonitorHotPlaywayDetailEnum format : values) {
            if (StringUtils.equals(format.getValue(),value)) {
                return format;
            }
        }
        return null;
    }
}
