package cn.com.duiba.odps.center.api.enums.monitor;

import org.apache.commons.lang.StringUtils;

/**
 * 销售额明细数据表字端枚举
 * Created by sunyan on 2020/2/26.
 */
public enum DataMonitorSalesDetailEnum {
    APPROVAL_CREATE_TIME("approval_create_time","审批流程创建时间"),
    SALE_NAME("sale_name","负责销售"),
    SALE_TEAM("sale_team","所在销售组"),
    OPERATE("operate","负责运营"),
    OPERATE_TEAM("operate_team","所在运营组"),
    CUSTOM_INDUSTRY("custom_industry","客户行业"),
    FRAMEWORK_AGREEMENT("framework_agreement","是否为框架协议"),
    CONTRACT_TYPE("contract_type","合同类型"),
    SIGNING_BODY("signing_body","签订主体"),
    ORDER_PRODUCT_TYPE("order_product_type","订购产品类型"),
    VERSION_NAME("version_name","积分商城版本名称"),
    PAYMENT_METHOD("payment_method","付款方式"),
    CONTRACT_AMOUNT("contract_amount","合同金额"),
    CUSTOMIZED_PRODUCT_AMOUNT("customized_product_amount","定制产品金额"),
    STANDARD_PRODUCT_AMOUNT("standard_product_amount","标准产品金额"),
    ACTUAL_ARRIVAL_AMOUNT("actual_arrival_amount","实际到账金额"),
    REPLICABLE_NUM("replicable_num","含可复制玩法数量");

    private String value;

    private String desc;

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
    DataMonitorSalesDetailEnum(String value,String desc)
    {
        this.value=value;
        this.desc=desc;
    }

    public static DataMonitorSalesDetailEnum getDataMonitorSalesDetailEnum(String value) {

        DataMonitorSalesDetailEnum[] values = DataMonitorSalesDetailEnum.values();
        for (DataMonitorSalesDetailEnum format : values) {
            if (StringUtils.equals(format.getValue(),value)) {
                return format;
            }
        }
        return null;
    }
}
