package cn.com.duiba.odps.center.api.dto.unionpay;


import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author chenzhenxing
 * @date 2021/12/23 4:05 下午
 */
public class MerchantsAndUserDataDto implements Serializable {
    private static final long serialVersionUID = 573292840809084571L;
    /**
     * 商户交易笔数分布
     */
    private Map<Integer,Long> merchantsTradeNumsMap;
    /**
     * 商户交易金额分布
     */
    private Map<Integer,Long> merchantsTradeAmountMap;
    /**
     * 用户周消费笔数
     */
    private Map<Integer,Long> userTradeNumsMap;
    /**
     * 各交易方式用户占比
     */
    private List<DlUnionPayConsumptionDailyDataDto> userNumsForTradeTypeList;

    /**
     * 当前消费用户数
     */
    private Long currentConsumptionNums;

    /**
     * 历史消费用户数
     */
    private Long historyConsumptionNums;

    public Map<Integer, Long> getMerchantsTradeNumsMap() {
        return merchantsTradeNumsMap;
    }

    public void setMerchantsTradeNumsMap(Map<Integer, Long> merchantsTradeNumsMap) {
        this.merchantsTradeNumsMap = merchantsTradeNumsMap;
    }

    public Map<Integer, Long> getMerchantsTradeAmountMap() {
        return merchantsTradeAmountMap;
    }

    public void setMerchantsTradeAmountMap(Map<Integer, Long> merchantsTradeAmountMap) {
        this.merchantsTradeAmountMap = merchantsTradeAmountMap;
    }

    public Map<Integer, Long> getUserTradeNumsMap() {
        return userTradeNumsMap;
    }

    public void setUserTradeNumsMap(Map<Integer, Long> userTradeNumsMap) {
        this.userTradeNumsMap = userTradeNumsMap;
    }

    public List<DlUnionPayConsumptionDailyDataDto> getUserNumsForTradeTypeList() {
        return userNumsForTradeTypeList;
    }

    public void setUserNumsForTradeTypeList(List<DlUnionPayConsumptionDailyDataDto> userNumsForTradeTypeList) {
        this.userNumsForTradeTypeList = userNumsForTradeTypeList;
    }

    public Long getCurrentConsumptionNums() {
        return currentConsumptionNums;
    }

    public void setCurrentConsumptionNums(Long currentConsumptionNums) {
        this.currentConsumptionNums = currentConsumptionNums;
    }

    public Long getHistoryConsumptionNums() {
        return historyConsumptionNums;
    }

    public void setHistoryConsumptionNums(Long historyConsumptionNums) {
        this.historyConsumptionNums = historyConsumptionNums;
    }
}
