package cn.com.duiba.odps.center.api.remoteservice.genie;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.genie.GenieRegistrationTableDto;
import cn.com.duiba.odps.center.api.dto.genie.GenieRegistrationTableFieldDto;

import java.util.List;


/**
 * 智能分析系统登记登记表服务
 * Created by sunyan on 2019/8/5.
 */
@AdvancedFeignClient
public interface RemoteGenieRegistrationTableService {
    /**
     * 同步登记业务表
     * @param tableName
     * @param tableAlias
     */
    int synchronizationTableStructure(String tableName,String tableAlias,Long registrationTableId,String admin);
    /**
     * 分页获取数据表
     */
    Page<GenieRegistrationTableDto> getTableList(Integer pageNo, Integer pageSize);
    /**
     * 分页按名称获取数据表
     */
    Page<GenieRegistrationTableDto> getTableListByLikeName(String registrationTableLikeName,Integer pageNo,Integer pageSize);
    /**
     * 获取对应表id的所有字段
     */
    List<GenieRegistrationTableFieldDto> selectByRegistrationTableId(Long registrationTableId);
    /**
     * 分页按别名获取数据表
     */
    Page<GenieRegistrationTableDto> getTableListByAlias(String registrationTableAlias,Integer pageNo, Integer pageSize);

    int deleteRegistrationTable(Long registrationTableId);

    List<String> getFiveTableName(String tableName);
}
