package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsAppItemDwmStatDto;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOdpsAppItemDwmStatService {
    /**
     * 查询商品销售数量
     * 1.有效查询参数appId,relationId(一般是appItemId),day,relationType,type
     * @param pojo
     * @return
     */
    public List<OdpsAppItemDwmStatDto> select(OdpsAppItemDwmStatDto pojo);

    /**
     * 全量查询商品数量
     *
     * @param appId
     * @param relationType tyep=1表示relationid是appItemId  type=2表示relationId是ItemId
     * @return
     */
    List<OdpsAppItemDwmStatDto> countByAppIdAndRelationIds(Long appId, Integer relationType);

}
