package cn.com.duiba.odps.center.api.remoteservice.data;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.data.OrdersStatisticsDto;
import java.util.Date;

/**
 * @author 刘凯
 * @Description: 应用纬度订单统计
 * @date 2019/5/09:55
 */
@AdvancedFeignClient
public interface RemoteOrderStatisticsService {



    /**
     * @Description: 根据指定日期查询
     * @date 2019/5/09:55
     */
    OrdersStatisticsDto selectBydate(Long appId,Date curDate) throws BizException;


    /**
     * @Description: 根据日期范围查询
     * @date 2019/5/09:55
     */
    Page<OrdersStatisticsDto> selectByStartEndDate(Long appId, Date startDate, Date endDate, Integer pageNo, Integer pageSize) throws BizException;


}
