package cn.com.duiba.odps.center.api.remoteservice.zjzy.xiaoxiaole;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.zjzy.xiaoxiaole.XxlCoinStatDto;
import cn.com.duiba.odps.center.api.dto.zjzy.xiaoxiaole.XxlLevelStatDto;
import cn.com.duiba.odps.center.api.dto.zjzy.xiaoxiaole.XxlPrizeStatDto;

import java.util.Date;

/**
 * @author haojiahong
 * @date 2020-11-11
 */
@AdvancedFeignClient
public interface RemoteZjzyXxlQueryStatService {

    /**
     * 抽奖统计
     *
     * @param statDate
     * @return
     */
    XxlPrizeStatDto getPrizeStat(Date statDate);

    /**
     * 关卡分布统计
     *
     * @param statDate
     * @return
     */
    XxlLevelStatDto getLevelStat(Date statDate);

    /**
     * 金币分布统计
     *
     * @param statDate
     * @return
     */
    XxlCoinStatDto getCoinStat(Date statDate);
}
