package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.risk.AppAccountWarnDto;

import java.util.Date;
import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemoteAppAccountWarnDataService
 * @Description: app账户支出预警所需数据
 * @date 2019/5/414:11
 */
@AdvancedFeignClient
public interface RemoteAppAccountWarnDataService {

    //统计数量（按照每半小时一条数据统计）
    int countByCondition(List<Long> appIds, Date startTime, Date finishTime);

    //条件查询list（按照每半小时一条数据统计）
    List<AppAccountWarnDto> queryListByCondition(List<Long> appIds, Date startTime, Date finishTime,Integer pageNo,Integer pageSize);

    //统计数量（按照每天一条数据统计 总量）
    int countTotalOnDay(List<Long> appIds,Date curDate);

    //条件查询list（按照每天一条数据统计 总量）
    List<AppAccountWarnDto> queryTotalListOnDay(List<Long> appIds,Date curDate,Integer pageNo,Integer pageSize);
}
