package cn.com.duiba.odps.center.api.dto.yearreview;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author haojiahong
 * @date 2022-05-10
 */
public class OrderStatTypeDto implements Serializable {

    private static final long serialVersionUID = 798442493986867822L;

    /**
     * 实物订单量
     */
    private Long objectNum;

    /**
     * 实物占比，保留两位小数，例如65.75
     */
    private String objectRate;

    /**
     * 优惠券&卡密订单量
     */
    private Long couponNum;

    /**
     * 优惠券&卡密占比，保留两位小数，例如65.75
     */
    private String couponRate;

    /**
     * 直充订单量
     */
    private Long virtualNum;

    /**
     * 直充占比，保留两位小数，例如65.75
     */
    private String virtualRate;

    /**
     * 开发者自有商品订单量
     */
    private Long appNum;

    /**
     * 开发者自有商品占比，保留两位小数，例如65.75
     */
    private String appRate;

    /**
     * 兑吧商品订单量
     */
    private Long duibaNum;

    /**
     * 兑吧商品占比，保留两位小数，例如65.75
     */
    private String duibaRate;


    /**
     * 二维表
     */
    private List<MonthBean> list;


    public static class MonthBean implements Serializable {

        private static final long serialVersionUID = -4160599827347100261L;

        /**
         * 时间，格式
         */
        private Date date;

        /**
         * 付费实物订单量
         */
        private Long monthObjectNum;

        /**
         * 有价卡券订单量
         */
        private Long monthVirtualNum;

        /**
         * 消耗金额，单位分
         */
        private Long monthMoney;

        public Date getDate() {
            return date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Long getMonthObjectNum() {
            return monthObjectNum;
        }

        public void setMonthObjectNum(Long monthObjectNum) {
            this.monthObjectNum = monthObjectNum;
        }

        public Long getMonthVirtualNum() {
            return monthVirtualNum;
        }

        public void setMonthVirtualNum(Long monthVirtualNum) {
            this.monthVirtualNum = monthVirtualNum;
        }

        public Long getMonthMoney() {
            return monthMoney;
        }

        public void setMonthMoney(Long monthMoney) {
            this.monthMoney = monthMoney;
        }
    }

    public Long getObjectNum() {
        return objectNum;
    }

    public void setObjectNum(Long objectNum) {
        this.objectNum = objectNum;
    }

    public Long getCouponNum() {
        return couponNum;
    }

    public void setCouponNum(Long couponNum) {
        this.couponNum = couponNum;
    }

    public Long getVirtualNum() {
        return virtualNum;
    }

    public void setVirtualNum(Long virtualNum) {
        this.virtualNum = virtualNum;
    }

    public Long getAppNum() {
        return appNum;
    }

    public void setAppNum(Long appNum) {
        this.appNum = appNum;
    }

    public Long getDuibaNum() {
        return duibaNum;
    }

    public void setDuibaNum(Long duibaNum) {
        this.duibaNum = duibaNum;
    }

    public List<MonthBean> getList() {
        return list;
    }

    public void setList(List<MonthBean> list) {
        this.list = list;
    }

    public String getObjectRate() {
        return objectRate;
    }

    public void setObjectRate(String objectRate) {
        this.objectRate = objectRate;
    }

    public String getCouponRate() {
        return couponRate;
    }

    public void setCouponRate(String couponRate) {
        this.couponRate = couponRate;
    }

    public String getVirtualRate() {
        return virtualRate;
    }

    public void setVirtualRate(String virtualRate) {
        this.virtualRate = virtualRate;
    }

    public String getAppRate() {
        return appRate;
    }

    public void setAppRate(String appRate) {
        this.appRate = appRate;
    }

    public String getDuibaRate() {
        return duibaRate;
    }

    public void setDuibaRate(String duibaRate) {
        this.duibaRate = duibaRate;
    }
}
