package cn.com.duiba.odps.center.api.dto.genie;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class ChartAndSqlDto implements Serializable {


    private static final long serialVersionUID = 7601589420394299746L;


    /**
     * 图表主键
     **/
    private Long id;
    /**
     * 图表名称
     **/
    private String chartName;
    /**
     * 图表创建者id
     **/
    private Long adminId;
    /**
     * 图表创建者姓名
     **/
    private String adminName;
    /**
     * 图表类型。1：折线图；2：柱状图；3：饼图；4：核心数据列表；5：热力图；6：数据列表；
     **/
    private Integer chartType;
    /**
     * 时间控件状态。0：关闭；1：开启
     **/
    private Boolean timeControlState;
    /**
     * 搜索控件状态。0：关闭；1：开启（暂时列表类型专属）
     **/
    private Boolean searchControlState;
    /**
     * json格式，搜索指标与对应的别名
     **/
    private List<JsonSearchTargetDto> jsonSearchTargetDtoList;
    /**
     * 维度，取自选定的数据表字段（X轴,列表类型没有）
     **/
    private String dimension;
    /**
     * 时间字段
     **/
    private String timeCondition;
    /**
     * 默认展示天数(不超过365天)
     **/
    private Integer defaultTimeSpan;
    /**
     * 筛选最大时间间隔（不超过365天）
     **/
    private Integer maxTimeSpan;
    /**
     * 目前单表查询只有一条数据
     **/
    private SqlConfigurationDto sqlConfigurationDto;

    /**
     * 指标描述
     **/
    private String targetDescription;
    /**
     * 指标描述开关
     **/
    private Boolean targetDescriptionState;

    /**
     * 指标单位，指标卡专有
     **/
    private String targetUnit;

    /**
     * 维度场景值
     **/
    private String dimesionScene;

    public String getDimesionScene() {
        return dimesionScene;
    }

    public void setDimesionScene(String dimesionScene) {
        this.dimesionScene = dimesionScene;
    }

    public String getTargetUnit() {
        return targetUnit;
    }

    public void setTargetUnit(String targetUnit) {
        this.targetUnit = targetUnit;
    }

    public String getTargetDescription() {
        return targetDescription;
    }

    public void setTargetDescription(String targetDescription) {
        this.targetDescription = targetDescription;
    }

    public Boolean getTargetDescriptionState() {
        return targetDescriptionState;
    }

    public void setTargetDescriptionState(Boolean targetDescriptionState) {
        this.targetDescriptionState = targetDescriptionState;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getChartName() {
        return chartName;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public String getAdminName() {
        return adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public Integer getChartType() {
        return chartType;
    }

    public void setChartType(Integer chartType) {
        this.chartType = chartType;
    }

    public Boolean getTimeControlState() {
        return timeControlState;
    }

    public void setTimeControlState(Boolean timeControlState) {
        this.timeControlState = timeControlState;
    }

    public Boolean getSearchControlState() {
        return searchControlState;
    }

    public void setSearchControlState(Boolean searchControlState) {
        this.searchControlState = searchControlState;
    }

    public List<JsonSearchTargetDto> getJsonSearchTargetDtoList() {
        return jsonSearchTargetDtoList;
    }

    public void setJsonSearchTargetDtoList(List<JsonSearchTargetDto> jsonSearchTargetDtoList) {
        this.jsonSearchTargetDtoList = jsonSearchTargetDtoList;
    }

    public String getDimension() {
        return dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getTimeCondition() {
        return timeCondition;
    }

    public void setTimeCondition(String timeCondition) {
        this.timeCondition = timeCondition;
    }

    public Integer getDefaultTimeSpan() {
        return defaultTimeSpan;
    }

    public void setDefaultTimeSpan(Integer defaultTimeSpan) {
        this.defaultTimeSpan = defaultTimeSpan;
    }

    public Integer getMaxTimeSpan() {
        return maxTimeSpan;
    }

    public void setMaxTimeSpan(Integer maxTimeSpan) {
        this.maxTimeSpan = maxTimeSpan;
    }

    public SqlConfigurationDto getSqlConfigurationDto() {
        return sqlConfigurationDto;
    }

    public void setSqlConfigurationDto(SqlConfigurationDto sqlConfigurationDto) {
        this.sqlConfigurationDto = sqlConfigurationDto;
    }

    @Override
    public String toString() {
        return "ChartAndSqlDto{" +
                "id=" + id +
                ", chartName='" + chartName + '\'' +
                ", adminId=" + adminId +
                ", adminName='" + adminName + '\'' +
                ", chartType=" + chartType +
                ", timeControlState=" + timeControlState +
                ", searchControlState=" + searchControlState +
                ", jsonSearchTargetDtoList=" + jsonSearchTargetDtoList +
                ", dimension='" + dimension + '\'' +
                ", timeCondition='" + timeCondition + '\'' +
                ", defaultTimeSpan=" + defaultTimeSpan +
                ", maxTimeSpan=" + maxTimeSpan +
                ", sqlConfigurationDto=" + sqlConfigurationDto +
                '}';
    }
}
