package cn.com.duiba.odps.center.api.param.data;

import java.io.Serializable;
import java.util.Date;

public abstract class HuanbeiLotsDrawingPageQueryBase implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * 数据生成日期
   */
  protected final Date date;

  /**
   * (结果集)起始偏移位置
   */
  protected final int offset;

  /**
   * (结果集)结束偏移位置
   */
  protected final int limit;

  /**
   * @param date T+1离线处理数据的生成日期,传参应该是当前日期的前一天
   * @param offset (结果集)起始偏移位置
   * @param limit (结果集)结束偏移位置
   */
  public HuanbeiLotsDrawingPageQueryBase(Date date, int offset, int limit) {
    if (offset < 0) {
      throw new IllegalArgumentException("(结果集)起始偏移位置offset不能小于0");
    }
    if (limit <= 0) {
      throw new IllegalArgumentException("(结果集)结束偏移位置必须大于0");
    }

    this.date = date;
    this.offset = offset;
    this.limit = limit;
  }

  public Date getDate() {
    return date;
  }

  public int getOffset() {
    return offset;
  }

  public int getLimit() {
    return limit;
  }
}
