package cn.com.duiba.odps.center.api.dto.zgrs;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:中国人寿通用上报数据报表
 */
@Data
public class ChinaLifeCommonReportDailyDO implements Serializable {


    private static final long serialVersionUID = -2282368238344910275L;
    /**
     * 主键ID
     */
    private Long id;
    /**
     * 用户uid
     */
    private String partnerUserId;
    /**
     * 活动编码(原来叫事件名称)
     */
    private String actCode;
    /**
     * 统计时间(yyyy-MM-dd)
     */
    private String actTime;
    /**
     * 访问渠道(APP-寿险，微信-寿险APP，微信-国寿e店，微信-云助理，微信-黄金宝典，微信-寿险微信公众号，微信-寿险小程序，微信-寿险企微，微信-国喜保，微信-广发微信公众号，微信-广发企微，微信-广发小程序，国寿e店，云助理，国寿e店-国喜保，云助理-国喜保，云助理-黄金宝典)'
     */
    private String channel;
    /**
     * 访问次数
     */
    private String visitCnt;
    /**
     * 平均停留时长
     */
    private String duration;
    /**
     * 互动次数
     */
    private String actCnt;
    /**
     * 转发活动次数
     */
    private String shareCnt;
    /**
     * 邀请新用户数
     */
    private Long inviteCnt;
    /**
     * 抽中奖品编号(多个奖品用,分隔)
     */
    private String winPrizeName;
    /**
     * 兑换奖品编号(多个奖品用,分隔)
     */
    private String prizeName;
    /**
     * 参与游戏活动编号(多次点击用,分隔)
     */
    private String playName;
    /**
     * 点击产品编号(多次点击用,分隔)
     */
    private String clickProduct;
    /**
     * 点击内容编号(多次点击用,分隔)
     */
    private String clickContent;
    /**
     * 点击服务功能编号(多次点击用,分隔)
     */
    private String clickService;
    /**
     * 备用1
     */
    private String spare1;
    /**
     * 备用2
     */
    private String spare2;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
}
