package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.FreeGroupDataDto;
import cn.com.duiba.odps.center.api.dto.OdpsHappyGroupDto;
import java.util.Date;

/**
 * @Author liugq
 * @Date 2019/3/22
 */
@AdvancedFeignClient
public interface RemoteFreeGroupDataService {
    /**
     * 根据活动id appid查询时间范围内数据信息
     * @param actId
     * @param appId
     * @param start
     * @param end
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<FreeGroupDataDto> selectByCondition(Long actId, Long appId,Integer throwType, Date start, Date end, int pageNo, int pageSize);

    /**
     * 累计发放奖品数量
     * @param actId
     * @param appId
     * @return
     */
    Integer sumRewardCount(Long actId, Long appId);

    /**
     * 根据日期查询
     * @param actId
     * @param appId
     * @param date
     * @return
     */
    FreeGroupDataDto findByDate(Long actId, Long appId, Date date);
}
