package cn.com.duiba.odps.center.api.remoteservice.pahp;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.paph.PaphAccessDo;
import cn.com.duiba.odps.center.api.dto.paph.PaphJoinPrizeDo;
import cn.com.duiba.odps.center.api.dto.paph.PaphPageDo;
import cn.com.duiba.odps.center.api.dto.paph.PaphSignDo;


/**
 * 平安普惠-统计数据回传
 * @author 郭海蓬
 */
@AdvancedFeignClient
public interface RemotePaphQueryStatService {
    /**
     * 活动访问数据
     */
    int countAccessDataByDate(String date);

    Page<PaphAccessDo> pageQueryAccessDataByDate(String date, Integer pageSize, Integer pageNo, Long lastId);

    /**
     * 活动参与数据
     */
    int countJoinPrizeDataByDate(String date);

    Page<PaphJoinPrizeDo> pageQueryJoinPrizeDataByDate(String date, Integer pageSize, Integer pageNo, Long lastId);

    /**
     * 签到数据
     */
    int countSignDataByDate(String date);

    Page<PaphSignDo> pageQuerySignDataByDate(String date, Integer pageSize, Integer pageNo, Long lastId);

    /**
     * 页面数据
     */
    int countPageDataByDate(String date);

    Page<PaphPageDo> pageQueryPageDataByDate(String date, Integer pageSize, Integer pageNo, Long lastId);
}
