package cn.com.duiba.odps.center.api.param.wanda;

import cn.com.duiba.api.bo.page.PageQuery;

import java.util.Date;

/**
 * 万达酒店对账单明细查询参数
 * @author zhangdaqing
 * @date 2025/10/13
 */
public class WandaOrderBillQueryParam extends PageQuery {

    private static final long serialVersionUID = 1L;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 交易号
     */
    private String transNo;

    /**
     * 交易流水号
     */
    private String transOrderNo;


    /**
     * 支付时间：年月日时分秒时间段
     */
    private Date payStartTime;
    private Date payEndTime;


    /**
     * 退款时间：年月日时分秒时间段
     */
    private Date refundStartTime;
    private Date refundEndTime;


    /**
     * 交易状态
     */
    private String transStatus;

    /**
     * 交易时间：
     * 用于筛选用户付款日期或用户退款日期
     */
    private Date transStartTime;
    private Date transEndTime;

    /**
     * 下单时间
     */
    private Date orderStartTime;
    private Date orderEndTime;

    /**
     * 订单状态
     */
    private String orderStatus;

    /**
     * 支付方式
     */
    private String payType;

    /**
     * 是否为供销存商品（1是，0否）
     */
    private String wanSupplierOrder;

    /**
     * 业务场景
     */
    private String busScene;

    /**
     * 创建时间-开始
     */
    private String gmtCreateStart;

    /**
     * 创建时间-结束
     */
    private String gmtCreateEnd;

    /**
     * 最后查询的ID（用于分页优化）
     */
    private Long lastId;

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getTransNo() {
        return transNo;
    }

    public void setTransNo(String transNo) {
        this.transNo = transNo;
    }

    public String getTransOrderNo() {
        return transOrderNo;
    }

    public void setTransOrderNo(String transOrderNo) {
        this.transOrderNo = transOrderNo;
    }

    public Date getPayStartTime() {
        return payStartTime;
    }

    public void setPayStartTime(Date payStartTime) {
        this.payStartTime = payStartTime;
    }

    public Date getPayEndTime() {
        return payEndTime;
    }

    public void setPayEndTime(Date payEndTime) {
        this.payEndTime = payEndTime;
    }

    public Date getRefundStartTime() {
        return refundStartTime;
    }

    public void setRefundStartTime(Date refundStartTime) {
        this.refundStartTime = refundStartTime;
    }

    public Date getRefundEndTime() {
        return refundEndTime;
    }

    public void setRefundEndTime(Date refundEndTime) {
        this.refundEndTime = refundEndTime;
    }

    public String getTransStatus() {
        return transStatus;
    }

    public void setTransStatus(String transStatus) {
        this.transStatus = transStatus;
    }

    public Date getTransStartTime() {
        return transStartTime;
    }

    public void setTransStartTime(Date transStartTime) {
        this.transStartTime = transStartTime;
    }

    public Date getTransEndTime() {
        return transEndTime;
    }

    public void setTransEndTime(Date transEndTime) {
        this.transEndTime = transEndTime;
    }

    public Date getOrderStartTime() {
        return orderStartTime;
    }

    public void setOrderStartTime(Date orderStartTime) {
        this.orderStartTime = orderStartTime;
    }

    public Date getOrderEndTime() {
        return orderEndTime;
    }

    public void setOrderEndTime(Date orderEndTime) {
        this.orderEndTime = orderEndTime;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getWanSupplierOrder() {
        return wanSupplierOrder;
    }

    public void setWanSupplierOrder(String wanSupplierOrder) {
        this.wanSupplierOrder = wanSupplierOrder;
    }

    public String getBusScene() {
        return busScene;
    }

    public void setBusScene(String busScene) {
        this.busScene = busScene;
    }

    public String getGmtCreateStart() {
        return gmtCreateStart;
    }

    public void setGmtCreateStart(String gmtCreateStart) {
        this.gmtCreateStart = gmtCreateStart;
    }

    public String getGmtCreateEnd() {
        return gmtCreateEnd;
    }

    public void setGmtCreateEnd(String gmtCreateEnd) {
        this.gmtCreateEnd = gmtCreateEnd;
    }

    public Long getLastId() {
        return lastId;
    }

    public void setLastId(Long lastId) {
        this.lastId = lastId;
    }
}

