package cn.com.duiba.odps.center.api.remoteservice.jszh;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.hzbank.HzBankBillDiDto;
import cn.com.duiba.odps.center.api.dto.jszh.BannerTaskDataEntity;
import cn.com.duiba.odps.center.api.dto.jszh.BaseDataEntity;
import cn.com.duiba.odps.center.api.dto.jszh.BoxDataEntity;
import cn.com.duiba.odps.center.api.dto.jszh.CardDataEntity;
import cn.com.duiba.odps.center.api.dto.jszh.PrizeDataEntity;
import cn.com.duiba.odps.center.api.dto.jszh.TaskDataEntity;
import cn.com.duiba.odps.center.api.dto.jszh.request.JszhCommonRequestDto;

import java.util.Date;
import java.util.List;

/**
 * @author lyj
 * @desc 江苏中行-开门红-数据看板
 * @date 2025-01-22 14:37:01
 */
@AdvancedFeignClient
public interface RemoteJszhService {

    /**
     * 江苏中行-卡片收集进度-统计-数据回流
     * @param jszhCommonRequestDto 统计日期
     * @return 数据集合
     */
    List<CardDataEntity> queryCardCollectData(JszhCommonRequestDto jszhCommonRequestDto);

    /**
     * 江苏中行-奖品领取数据-统计-数据回流
     * @param jszhCommonRequestDto 统计日期
     * @return 数据集合
     */
    List<PrizeDataEntity> queryPrizeData(JszhCommonRequestDto jszhCommonRequestDto);

    /**
     * 江苏中行-引流区任务完成数据-统计-数据回流
     * @param jszhCommonRequestDto 公共请求参数
     * @return 数据集合
     */
    List<BannerTaskDataEntity> queryTaskBannerCompleteData(JszhCommonRequestDto jszhCommonRequestDto);

    /**
     * 江苏中行-基础数据-统计-数据回流
     * @param jszhCommonRequestDto 公共请求参数
     * @return 数据集合
     */
    List<BaseDataEntity> queryBaseData(JszhCommonRequestDto jszhCommonRequestDto);

    /**
     * 江苏中行-任务数据-统计-数据回流
     * @param jszhCommonRequestDto 公共请求参数
     * @return 数据集合
     */
    List<TaskDataEntity> queryTaskData(JszhCommonRequestDto jszhCommonRequestDto);

    /**
     * 江苏中行-宝箱数据-统计-数据回流
     * @param jszhCommonRequestDto 公共请求参数
     * @return 数据集合
     */
    List<BoxDataEntity> queryBoxData(JszhCommonRequestDto jszhCommonRequestDto);

}
