package cn.com.duiba.odps.center.api.remoteservice.wanda;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.wanda.WandaOrderBillDTO;
import cn.com.duiba.odps.center.api.param.wanda.WandaOrderBillQueryParam;

import java.util.Date;
import java.util.List;

/**
 * 万达酒店对账单明细远程服务接口
 * @author zhangdaqing
 * @Description 提供万达酒店对账单明细数据的查询服务
 * @date 2025/10/13 15:52
 */
@AdvancedFeignClient
public interface RemoteWandaOrderBillService {

    /**
     * 分页查询万达酒店对账单明细数据
     * 支持所有字段的条件查询和分页
     *
     * @param queryParam 查询参数，包含所有可搜索字段和分页信息
     * @return 对账单明细分页数据
     */
    Page<WandaOrderBillDTO> pageQueryOrderBillList(WandaOrderBillQueryParam queryParam);

    /**
     * 查询对账单明细数据总数
     * 根据查询参数统计符合条件的记录总数
     *
     * @param queryParam 查询参数
     * @return 符合条件的记录总数
     */
    int countOrderBillByCondition(WandaOrderBillQueryParam queryParam);

    /**
     * 根据订单号查询对账单明细
     *
     * @param orderNum 订单号
     * @return 对账单明细数据，如果不存在则返回null
     */
    WandaOrderBillDTO queryOrderBillByOrderNum(String orderNum);

    /**
     * 根据交易号查询对账单明细
     * 查询逻辑：匹配 pay_trans_no 或 refund_trans_no
     *
     * @param transNo 交易号
     * @return 对账单明细数据，如果不存在则返回null
     */
    WandaOrderBillDTO queryOrderBillByTransNo(String transNo);

    /**
     * 根据交易流水号查询对账单明细
     * 查询逻辑：匹配 pay_trans_order_no 或 refund_trans_order_no
     *
     * @param transOrderNo 交易流水号
     * @return 对账单明细数据，如果不存在则返回null
     */
    WandaOrderBillDTO queryOrderBillByTransOrderNo(String transOrderNo);

    /**
     * 根据下单时间范围查询对账单明细列表（不分页）
     * 适用于数据导出等场景
     *
     * @param orderStartTime 下单开始时间
     * @param orderEndTime 下单结束时间
     * @return 对账单明细列表
     */
    List<WandaOrderBillDTO> queryOrderBillListByOrderTimeRange(Date orderStartTime, Date orderEndTime);

    /**
     * 根据交易状态和订单状态查询对账单明细列表
     *
     * @param transStatus 交易状态
     * @param orderStatus 订单状态
     * @param pageNo 页码
     * @param pageSize 每页大小
     * @return 对账单明细分页数据
     */
    Page<WandaOrderBillDTO> queryOrderBillListByStatus(String transStatus, String orderStatus, 
                                                         Integer pageNo, Integer pageSize);
}
