package cn.com.duiba.odps.center.api.remoteservice.common;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.param.common.GenericQueryParam;

import java.util.List;

/**
 * 通用查询远程服务接口
 * 提供通用的数据库查询服务，支持动态表名和多种查询条件
 * 支持泛型：通过 queryParam.setResultType(Class) 指定返回类型，实现类会自动转换
 * 
 * 注意：虽然接口使用泛型，但由于 Feign 的限制，实际运行时类型会被擦除。
 * 实现类会根据 queryParam 中的 resultType 进行类型转换。
 * 
 * @author zhangdaqing
 * @date 2025/10/13
 */
@AdvancedFeignClient
public interface RemoteGenericQueryService {
    
    /**
     * 分页查询（泛型方法）
     * 通过 queryParam.setResultType(Class) 指定返回类型，实现类会自动转换为指定类型
     * 
     * 使用示例：
     * <pre>
     * GenericQueryParam param = new GenericQueryParam("table_name");
     * param.setResultType(WandaOrderBillDTO.class);
     * Page&lt;WandaOrderBillDTO&gt; page = remoteService.pageQuery(param);
     * </pre>
     *
     * @param queryParam 查询参数（可通过 setResultType 指定返回类型）
     * @param <T> 返回类型泛型
     * @return 分页结果（类型由 queryParam.resultType 决定）
     */
    <T> Page<T> pageQuery(GenericQueryParam queryParam);
    
    /**
     * 统计总数
     *
     * @param queryParam 查询参数
     * @return 记录总数
     */
    int count(GenericQueryParam queryParam);
    

}

