package cn.com.duiba.odps.center.api.remoteservice.data;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiGohomeActionDataDto;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiGohomeDailyDataDto;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiGohomePrizeDataDto;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiInviteDailyDataDto;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiInviteTaskDataDto;

import java.util.Date;
import java.util.List;

/**
 * 花呗 - 点亮回家路/邀请有礼数据接口
 *
 * @Author: xuwei
 * @Date: 2019/11/6 15:54
 */
@AdvancedFeignClient
public interface RemoteHuanbeiInviteAndGoHomeDataService {
    /**
     * 查询用户访问数据
     *
     * @param date
     * @return
     */
    HuanbeiInviteDailyDataDto findDailyData(Date date);

    /**
     * 查询用户任务数据
     *
     * @param date
     * @param offset
     * @param size
     * @return
     */
    List<HuanbeiInviteTaskDataDto> findDailyUserTaskData(Date date, int offset, int size);

    /**
     * 点亮回家路-每日汇总数据
     *
     * @param date
     * @return
     */
    HuanbeiGohomeDailyDataDto findGoHomeDailyData(Date date);


    /**
     * 点亮回家路-每日发放奖品数据
     *
     * @param date
     * @return
     */
    List<HuanbeiGohomePrizeDataDto> findGoHomePrizeData(Date date);

    /**
     * 点亮回家路-每日用户行为数据
     *
     * @param date
     * @param offset
     * @param size
     * @return
     */
    List<HuanbeiGohomeActionDataDto> findGoHomeUserActionData(Date date, int offset, int size);
}
