package cn.com.duiba.odps.center.api.remoteservice.data;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiUserAccessDto;
import cn.com.duiba.odps.center.api.dto.data.HuanbeiUserTaskDto;

import java.util.Date;
import java.util.List;

/**
 * 花呗双十一活动用户数据查询
 *
 * @Author: xuwei
 * @Date: 2019/11/6 15:54
 */
@AdvancedFeignClient
public interface RemoteHuanbeiUserDataService {
    /**
     * 查询用户访问数据
     *
     * @param date
     * @param offset
     * @param size
     * @return
     */
    List<HuanbeiUserAccessDto> findDailyUserAccessData(Date date, int offset, int size);

    /**
     * 查询用户任务数据
     *
     * @param date
     * @param offset
     * @param size
     * @return
     */
    List<HuanbeiUserTaskDto> findDailyUserTaskData(Date date, int offset, int size);
}
